Attribute VB_Name = "MSR_FNC"
'########################################################################################################
'##################### GLOBALE FUNKTIONEN ZUR VERWALTUNG DER PEILUNGD-DATEN DER FLGE ###################
'########################################################################################################


Dim DATfly%(), DATalp%(), DATgma%()

Global IDXang_msr As Integer '..................................... Index des aktuellen Winkels (Alpha=0)

'********************************************************************************************************
'************************************ ENTLADENEN DES EINGABE-BEREICHES **********************************
'
  Sub MsrCtrSavInpValue(IDXang%, CLCfly%)
'
'........................................................................................................
  
IDXstc% = MsrCtr.IDXrec
NBRcmp% = Val(CmpCtr.RECdat(CmpCtr.IDXrec))

'............................................................................................ Formatieren
VALtxt_new$ = UCase(Trim(MSR_CTR.ValInpTxt.Text))

Pq% = InStr(VALtxt_new$, " ")

  Do While Pq% > 0
    VALtxt_new$ = Left(VALtxt_new$, Pq% - 1) + Right(VALtxt_new$, Len(VALtxt_new$) - Pq%)
    Pq% = InStr(VALtxt_new$, " ")
  Loop
  
      
  Select Case VALtxt_new$
    Case "" '...................................................................................... Clear
      MsrCtrClrStcData IDXstc%
      Exit Sub
    
    Case "--", "TL" '.......................................................................... TrackLost
      MsrCtrSetStcTrkLost IDXstc%
      Exit Sub
  
    Case "DQ" '............................................................................. Disqualified
      MsrCtrSetFlyDisQualified
      Exit Sub
      
    Case Else
      VALtxt_new$ = S1xFmtInpValue$(VALtxt_new$, "NBR_3,2")
        If TXTmsg_stp > "" Then Exit Sub
        
        If IDXang% = 1 And Val(VALtxt_new$) < 0 Then
            
            If LCDlng_s1x = "GER" Then
              TXTmsg_stp = "- Der VertikalWinkel darf nicht kleiner als Null sein -"
            Else
              TXTmsg_stp = "- Vertical Tracking Angle must not be negative -"
            End If
            
          Exit Sub
        End If
  End Select
  

MSR_CTR.ValInpTxt.Text = " " + VALtxt_new$

'........................................................................................ Vorherige Werte
RECx$ = MsrCtr.RECdat(IDXstc%)
P1% = InStr(RECx$, Chr(1))
P2% = InStr(P1%, RECx$, Chr(2))
P3% = InStr(P2%, RECx$, Chr(3))

ALPtxt_set$ = Mid(RECx$, P1% + 1, P2% - P1% - 1)
GMAtxt_set$ = Mid(RECx$, P2% + 1, P3% - P2% - 1)
If IDXang% = 0 Then VALtxt_set$ = ALPtxt_set$ Else VALtxt_set$ = GMAtxt_set$
      
    If VALtxt_new$ = VALtxt_set$ And CLCfly% = 0 Then Exit Sub
    
'............................................................................................. Neue Werte

  If IDXang% = 0 Then
    ALPtxt_new$ = VALtxt_new$
    If GMAtxt_set$ = TL$ Then GMAtxt_new$ = "" Else GMAtxt_new$ = GMAtxt_set$
  Else
    If ALPtxt_set$ = TL$ Then ALPtxt_new$ = "" Else ALPtxt_new$ = ALPtxt_set$
    GMAtxt_new$ = VALtxt_new$
  End If

VALx$ = ALPtxt_new$: Pq% = InStr(VALx$, ","): If Pq% > 0 Then Mid(VALx$, Pq%, 1) = "."
ALPnbr_new! = Val(VALx$)
    
VALx$ = GMAtxt_new$: Pq% = InStr(VALx$, ","): If Pq% > 0 Then Mid(VALx$, Pq%, 1) = "."
GMAnbr_new! = Val(VALx$)

  '............................................................................................ SPEICHERN
  If VALtxt_new$ <> VALtxt_set$ Then
        
            QRYx$ = " SELECT * "
    QRYx$ = QRYx$ + " FROM s1x_msr "
    QRYx$ = QRYx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
    QRYx$ = QRYx$ + "  AND cmp_index =" + Str(NBRcmp%)
    QRYx$ = QRYx$ + "  AND fly_index =" + Str(IDXfly_s1x)
    QRYx$ = QRYx$ + "  AND stc_index =" + Str(IDXstc%)
    On Error GoTo SavAccErr
    Set CRSobj_s1x = DBSobj_s1x.OpenRecordset(QRYx$, 2, 0)
    On Error GoTo 0
      
      
      If Not CRSobj_s1x.EOF Then
        CRSobj_s1x.Edit
        On Error GoTo SavUpdErr
      Else
      
        QRYx$ = " SELECT * FROM s1x_msr WHERE cnt_index = 0"
        On Error GoTo SavAccErr
        Set CRSobj_s1x = DBSobj_s1x.OpenRecordset(QRYx$, 2, 0)
        On Error GoTo 0
      
          If Not CRSobj_s1x.EOF Then
            CRSobj_s1x.Edit
            On Error GoTo SavUpdErr
          Else
            Set CRSobj_s1x = DBSobj_s1x.OpenRecordset("s1x_msr", 2, 8)
            CRSobj_s1x.AddNew
            On Error GoTo SavInsErr
          End If
      
      End If
      
    CRSobj_s1x("cnt_index") = IDXcnt_s1x
    CRSobj_s1x("cmp_index") = NBRcmp%
    CRSobj_s1x("fly_index") = IDXfly_s1x
    CRSobj_s1x("stc_index") = IDXstc%
    CRSobj_s1x("hrz_angle") = ALPnbr_new!: CRSobj_s1x("vtc_angle") = GMAnbr_new!
    CRSobj_s1x.Update
    
    CRSobj_s1x.Close
    On Error GoTo 0
  
    '................................................................................ LISTE AKTUALISIEREN
    RECx$ = Left(RECx$, P1%) + ALPtxt_new$ + Chr(2) + GMAtxt_new$ + Right(RECx$, Len(RECx$) - P3% + 1)
    MsrCtr.RECdat(IDXstc%) = RECx$
    
    ROWx% = IDXstc% - MsrCtr.NBRscr
    X1% = 15: X2% = MSR_CTR.RecLstPct.Width - 15
    YY& = TOPspc_lst + (ROWx% - 1) * HGHrow_lst
    Y1% = YY& - 30: Y2% = YY& + HGHfrm_lst
    MSR_CTR.RecLstPct.Line (X1%, Y1%)-(X2%, Y2%), COLbkc_lst, BF
    MsrCtrShwRecord IDXstc%, YY&
  End If
  
      
      If CLCfly% = 0 Then Exit Sub
      

'........................................................................... BERERECHNUNGEN AKTUALISIEREN
ALPnbr_old! = ALPstc_fly(IDXstc%): GMAnbr_old! = GMAstc_fly(IDXstc%)

  If ALPnbr_new! <> ALPnbr_old! Or GMAnbr_new! <> GMAnbr_old! Then
    ALPstc_fly(IDXstc%) = ALPnbr_new!:  GMAstc_fly(IDXstc%) = GMAnbr_new!
    
    '.................................................................. Prfung fr die brigen Stationen
    NBRrec_val% = 0
      
      For STCi% = 1 To MsrCtr.NBRrec
        If GMAstc_fly(STCi%) <> 0 Then NBRrec_val% = NBRrec_val% + 1
      Next STCi%
  
        If NBRrec_val% < 2 Then Exit Sub
        
    MSR_CTR.MousePointer = 11
    MSR_CTR.RecLstPct.MousePointer = 11
    DoEvents
    MSR_CTR.Enabled = 0
    
    ALTfly_old& = ALTcmp_fly(CmpCtr.IDXrec, IDXfly_s1x)
    ClcCtrClcFlight CmpCtr.IDXrec, IDXfly_s1x
    CmpCtrShwFlyData CmpCtr.IDXrec, IDXfly_s1x
    
      If ALTcmp_fly(CmpCtr.IDXrec, IDXfly_s1x) <> ALTfly_old& Then
        ALTcmp_old& = ALTcnt_cmp(CmpCtr.IDXrec)
        ClcCtrClcCmpResult CmpCtr.IDXrec
      
          If ALTcnt_cmp(CmpCtr.IDXrec) <> ALTcmp_old& Then
            ClcCtrClcCmpPositions
          
              For IDXcmp% = 1 To CmpCtr.NBRrec
                CmpCtrShwCmpPosition IDXcmp%
              Next IDXcmp%
            
            CmpCtrDrwFrame CmpCtr.IDXrec, 2
          End If
      
      End If


    MSR_CTR.FlyDsqImg.Top = 0
      
      If STScmp_fly(CmpCtr.IDXrec, IDXfly_s1x) = "TL" Then
        MSR_CTR.FlyTrkImg.Top = -600
      Else
        MSR_CTR.FlyTrkImg.Top = 0
      End If
    
    '..................................................................... nderungen in s1x_clc Anzeigen
    If Mid(LSTfrm_opn, 4, 1) = "*" Then ClcCtrLodDuoData

    Beep
    MSR_CTR.MousePointer = 0
    MSR_CTR.RecLstPct.MousePointer = 99
    MSR_CTR.Enabled = 1
  End If


                                                                                                 Exit Sub
'********************************************************************************************************
'--------------------------------------------------------------------------------------------------------
'--------------------------------------------------------------------------------------------------------
SavAccErr:
S1xDbsAccError 1
Resume SavInpEnd

SavUpdErr:
S1xDbsAccError 2
Resume SavInpEnd

SavInsErr:
S1xDbsAccError 3
Resume SavInpEnd

SavInpEnd:
MSR_CTR.MousePointer = 0
            
'********************************************************************************************************
                                                                                                  End Sub



'********************************************************************************************************
'******************************** LSCHEN DER PEILUNGS-DATEN EINER STATION ******************************
'
  Sub MsrCtrClrStcData(IDXstc%)
'
'
'   Lschen der Daten der letzten Station >> Lschen des Fluges
'                  Lschen von Daten <> 0 >> Berechnen des Fluges
'
'........................................................................................................
  
      
'........................................................................................ Vorherige Werte
RECx$ = MsrCtr.RECdat(IDXstc%)
P1% = InStr(RECx$, Chr(1))
P2% = InStr(P1%, RECx$, Chr(2))
P3% = InStr(P2%, RECx$, Chr(3))

ALPtxt_old$ = Mid(RECx$, P1% + 1, P2% - P1% - 1)
GMAtxt_old$ = Mid(RECx$, P2% + 1, P3% - P2% - 1)
      
    If ALPtxt_old$ + GMAtxt_old$ = "" Then Exit Sub
    

QQ$ = Chr$(1) + Chr(2) + Chr(3)

  For STCi% = 1 To MsrCtr.NBRrec
    If STCi% <> IDXstc% And InStr(MsrCtr.RECdat(STCi%), QQ$) = 0 Then Exit For
  Next STCi%
  
    If STCi% > MsrCtr.NBRrec Then MsrCtrClrFlight: Exit Sub '.......... Lschen der letzten PeilungsDaten


'................................................................. LSCHEN DES RECORDS DER PEILUNGS-DATEN
NBRcmp% = Val(CmpCtr.RECdat(CmpCtr.IDXrec))
        
        UPDx$ = " UPDATE s1x_msr "
UPDx$ = UPDx$ + " SET cnt_index = 0 "
UPDx$ = UPDx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
UPDx$ = UPDx$ + "  AND cmp_index =" + Str(NBRcmp%)
UPDx$ = UPDx$ + "  AND fly_index =" + Str(IDXfly_s1x)
UPDx$ = UPDx$ + "  AND stc_index =" + Str(IDXstc%)
On Error GoTo SavUpdErr
DBSobj_s1x.Execute UPDx$
On Error GoTo 0

  
'................................................................................... Record Aktualisieren
RECx$ = Left(RECx$, P1%) + Chr(2) + Right(RECx$, Len(RECx$) - P3% + 1)
MsrCtr.RECdat(IDXstc%) = RECx$

'.................................................................................. Anzeige Aktualisieren
ROWx% = IDXstc% - MsrCtr.NBRscr
X1% = 15: X2% = MSR_CTR.RecLstPct.Width - 15
YY& = TOPspc_lst + (ROWx% - 1) * HGHrow_lst
Y1% = YY& - 30: Y2% = YY& + HGHfrm_lst
MSR_CTR.RecLstPct.Line (X1%, Y1%)-(X2%, Y2%), COLbkc_lst, BF
MsrCtrShwRecord IDXstc%, YY&
  

'............................................................................. BERECHNUNGEN AKTUALISIEREN
ALPstc_fly(IDXstc%) = 0: GMAstc_fly(IDXstc%) = 0
  
ClcCtrClcFlight CmpCtr.IDXrec, IDXfly_s1x
CmpCtrShwFlyData CmpCtr.IDXrec, IDXfly_s1x
ClcCtrClcCmpResult CmpCtr.IDXrec

If Mid(LSTfrm_opn, 4, 1) = "*" Then ClcCtrLodDuoData

                                                                                                 Exit Sub
'********************************************************************************************************
'--------------------------------------------------------------------------------------------------------
'--------------------------------------------------------------------------------------------------------
SavAccErr:
S1xDbsAccError 1
Resume SavInpEnd

SavUpdErr:
S1xDbsAccError 2
Resume SavInpEnd

SavInsErr:
S1xDbsAccError 3
Resume SavInpEnd

SavInpEnd:
MSR_CTR.MousePointer = 0
            
'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'*********************************** LSCHEN DER DATEN EINES FLUGES *************************************
'
  Sub MsrCtrClrFlight()
'
'........................................................................................................
  

MSR_CTR.ValInpTxt.Text = " "
NBRcmp% = Val(CmpCtr.RECdat(CmpCtr.IDXrec))
      

'................................................................................. LSCHEN DER FLUG-DATEN
        
        UPDx$ = " UPDATE s1x_fly "
UPDx$ = UPDx$ + " SET cnt_index = 0 "
UPDx$ = UPDx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
UPDx$ = UPDx$ + "  AND cmp_index =" + Str(NBRcmp%)
UPDx$ = UPDx$ + "  AND fly_index =" + Str(IDXfly_s1x)
On Error GoTo SavUpdErr
DBSobj_s1x.Execute UPDx$
On Error GoTo 0

ALTcmp_fly(CmpCtr.IDXrec, IDXfly_s1x) = 0
ERRcmp_fly(CmpCtr.IDXrec, IDXfly_s1x) = 0
STScmp_fly(CmpCtr.IDXrec, IDXfly_s1x) = ""
MSR_CTR.FlyRmvImg.Top = 0
MSR_CTR.FlyTrkImg.Top = 0
MSR_CTR.FlyDsqImg.Top = 0

CmpCtrShwFlyData CmpCtr.IDXrec, IDXfly_s1x
ClcCtrClcCmpResult CmpCtr.IDXrec

'............................................................................. LSCHEN DER PEILUNGS-DATEN
        
        UPDx$ = " UPDATE s1x_msr "
UPDx$ = UPDx$ + " SET cnt_index = 0 "
UPDx$ = UPDx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
UPDx$ = UPDx$ + "  AND cmp_index =" + Str(NBRcmp%)
UPDx$ = UPDx$ + "  AND fly_index =" + Str(IDXfly_s1x)
On Error GoTo SavUpdErr
DBSobj_s1x.Execute UPDx$
On Error GoTo 0

  
  '................................................................................ Records Aktualisieren
  For STCi% = 1 To MsrCtr.NBRrec
    ALPstc_fly(STCi%) = 0: GMAstc_fly(STCi%) = 0
  
    RECx$ = LTrim(Str(STCi%)): If STCi% < 10 Then RECx$ = "0" + RECx$
    RECx$ = "Number  " + RECx$ + Chr(1) + Chr(2) + Chr(3)
    MsrCtr.RECdat(STCi%) = RECx$
  Next STCi%

MsrCtrDrwFrame MsrCtr.IDXrec, 0

MsrCtr.IDXrec = 1
MsrCtr.NBRscr = 0

MsrCtrShwRecList
S1xFrmSetScrPointer MSR_CTR, MsrCtr.NBRrec, MsrCtr.NBRrow, MsrCtr.NBRscr
MsrCtrLodInpValue 0
MsrCtrDrwFrame MsrCtr.IDXrec, 1

'................................................................... LSCHEN DER DATEN DER STATIONS-PAARE
        
        UPDx$ = " UPDATE s1x_clc "
UPDx$ = UPDx$ + " SET cnt_index = 0 "
UPDx$ = UPDx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
UPDx$ = UPDx$ + "  AND cmp_index =" + Str(NBRcmp%)
UPDx$ = UPDx$ + "  AND fly_index =" + Str(IDXfly_s1x)
On Error GoTo SavUpdErr
DBSobj_s1x.Execute UPDx$
On Error GoTo 0

If Mid(LSTfrm_opn, 4, 1) = "*" Then ClcCtrLodDuoData


                                                                                                 Exit Sub
'********************************************************************************************************
'--------------------------------------------------------------------------------------------------------
'--------------------------------------------------------------------------------------------------------
SavAccErr:
S1xDbsAccError 1
Resume SavInpEnd

SavUpdErr:
S1xDbsAccError 2
Resume SavInpEnd

SavInsErr:
S1xDbsAccError 3
Resume SavInpEnd

SavInpEnd:
MSR_CTR.MousePointer = 0
            
'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'************************************ EINGABE TRACK-LOST FR EINE STATION *******************************
'
  Sub MsrCtrSetStcTrkLost(IDXstc%)
'
'
'   Erster Eintrag fr den aktuellen Flug >> Setzen TL bei FlugDaten
'                  Lschen von Daten <> 0 >> Berechnen des Fluges
'
'........................................................................................................
  

TL$ = "- - "
MSR_CTR.ValInpTxt.Text = " " + TL$


'........................................................................................ Vorherige Werte
RECx$ = MsrCtr.RECdat(IDXstc%)
P1% = InStr(RECx$, Chr(1))
P2% = InStr(P1%, RECx$, Chr(2))
P3% = InStr(P2%, RECx$, Chr(3))

ALPtxt_old$ = Mid(RECx$, P1% + 1, P2% - P1% - 1)
GMAtxt_old$ = Mid(RECx$, P2% + 1, P3% - P2% - 1)
      
    If ALPtxt_old$ = TL$ And GMAtxt_old$ = TL$ Then Exit Sub '??

'...................................................................... Prfung fr die brigen Stationen
NBRrec_tl% = 1
  
  For STCi% = 1 To MsrCtr.NBRrec
    If STCi% <> IDXstc% Then
      If InStr(MsrCtr.RECdat(STCi%), TL$) > 0 Then NBRrec_tl% = NBRrec_tl% + 1
    End If
  Next STCi%
  
  
    If NBRrec_tl% = MsrCtr.NBRrec Then MsrCtrSetFlyTrkLost: Exit Sub '......... TrackLost fr Flug Setzen
    
'................................................................................... TRACK-LOST SPEICHERN

'................................................................. StartNummer des aktuellen Wettkmpfers
Pq% = InStr(CmpCtr.RECdat(CmpCtr.IDXrec), Chr(1))
CMPnbr$ = Left(CmpCtr.RECdat(CmpCtr.IDXrec), Pq% - 1)
IDXcmp% = Val(CMPnbr$)

        QRYx$ = " SELECT * FROM s1x_msr "
QRYx$ = QRYx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
QRYx$ = QRYx$ + "  AND cmp_index =" + CMPnbr$
QRYx$ = QRYx$ + "  AND fly_index =" + Str(IDXfly_s1x)
QRYx$ = QRYx$ + "  AND stc_index =" + Str(IDXstc%)

On Error GoTo SavAccErr
Set CRSobj_s1x = DBSobj_s1x.OpenRecordset(QRYx$, 2, 0)
On Error GoTo 0

  If Not CRSobj_s1x.EOF Then
    CRSobj_s1x.Edit
    On Error GoTo SavUpdErr
  Else
    QRYx$ = " SELECT * FROM s1x_msr WHERE cnt_index = 0"
    On Error GoTo SavAccErr
    Set CRSobj_s1x = DBSobj_s1x.OpenRecordset(QRYx$, 2, 0)
    On Error GoTo 0
  
      If Not CRSobj_s1x.EOF Then
        CRSobj_s1x.Edit
        On Error GoTo SavUpdErr
      Else
        Set CRSobj_s1x = DBSobj_s1x.OpenRecordset("s1x_msr", 2, 8)
        CRSobj_s1x.AddNew
        On Error GoTo SavInsErr
      End If
  End If
  
CRSobj_s1x("cnt_index") = IDXcnt_s1x
CRSobj_s1x("cmp_index") = IDXcmp%
CRSobj_s1x("fly_index") = IDXfly_s1x
CRSobj_s1x("stc_index") = IDXstc%
CRSobj_s1x("hrz_angle") = Null
CRSobj_s1x("vtc_angle") = Null
CRSobj_s1x.Update

CRSobj_s1x.Close
On Error GoTo 0


ALPstc_fly(IDXstc%) = 0: GMAstc_fly(IDXstc%) = 0

'................................................................................... Record Aktualisieren
RECx$ = Left(RECx$, P1%) + TL$ + Chr(2) + TL$ + Right(RECx$, Len(RECx$) - P3% + 1)
MsrCtr.RECdat(IDXstc%) = RECx$

'.................................................................................. Anzeige Aktualisieren
ROWx% = IDXstc% - MsrCtr.NBRscr
X1% = 15: X2% = MSR_CTR.RecLstPct.Width - 15
YY& = TOPspc_lst + (ROWx% - 1) * HGHrow_lst
Y1% = YY& - 30: Y2% = YY& + HGHfrm_lst
MSR_CTR.RecLstPct.Line (X1%, Y1%)-(X2%, Y2%), COLbkc_lst, BF
MsrCtrShwRecord IDXstc%, YY&

'............................................................................. BERECHNUNGEN AKTUALISIEREN
ClcCtrClcFlight CmpCtr.IDXrec, IDXfly_s1x
CmpCtrShwFlyData CmpCtr.IDXrec, IDXfly_s1x

ALTcmp_old& = ALTcnt_cmp(CmpCtr.IDXrec)
ClcCtrClcCmpResult CmpCtr.IDXrec
  
  If ALTcnt_cmp(CmpCtr.IDXrec) <> ALTcmp_old& Then
    ClcCtrClcCmpPositions
  
      For IDXcmp% = 1 To CmpCtr.NBRrec
        CmpCtrShwCmpPosition IDXcmp%
      Next IDXcmp%
    
    CmpCtrDrwFrame CmpCtr.IDXrec, 2
  End If

If Mid(LSTfrm_opn, 4, 1) = "*" Then ClcCtrLodDuoData
      


                                                                                                 Exit Sub
'********************************************************************************************************
'--------------------------------------------------------------------------------------------------------
'--------------------------------------------------------------------------------------------------------
SavAccErr:
S1xDbsAccError 1
Resume SavInpEnd

SavUpdErr:
S1xDbsAccError 2
Resume SavInpEnd

SavInsErr:
S1xDbsAccError 3
Resume SavInpEnd

SavInpEnd:
MSR_CTR.MousePointer = 0
            
'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'************************************ EINGABE TRACK-LOST FR EINEN FLUG *********************************
'
  Sub MsrCtrSetFlyTrkLost()
'
'........................................................................................................
  

TL$ = "- - "
MSR_CTR.ValInpTxt.Text = TL$
NBRcmp% = Val(CmpCtr.RECdat(CmpCtr.IDXrec))

'......................................................................... TRACK-LOST FR DEN FLUG SETZEN
        
        QRYx$ = " SELECT * "
QRYx$ = QRYx$ + " FROM s1x_fly "
QRYx$ = QRYx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
QRYx$ = QRYx$ + "   AND cmp_index =" + Str(NBRcmp%)
QRYx$ = QRYx$ + "   AND fly_index =" + Str(IDXfly_s1x)
On Error GoTo SavAccErr
Set CRSobj_s1x = DBSobj_s1x.OpenRecordset(QRYx$, 2, 0)
On Error GoTo 0
  
  If Not CRSobj_s1x.EOF Then
    CRSobj_s1x.Edit
    On Error GoTo SavUpdErr
  
  Else
  
            QRYx$ = " SELECT * "
    QRYx$ = QRYx$ + " FROM s1x_fly "
    QRYx$ = QRYx$ + " WHERE cnt_index = 0"
    On Error GoTo SavAccErr
    Set CRSobj_s1x = DBSobj_s1x.OpenRecordset(QRYx$, 2, 0)
    On Error GoTo 0
  
      If Not CRSobj_s1x.EOF Then
        CRSobj_s1x.Edit
        On Error GoTo SavUpdErr
        
        CRSobj_s1x("xxx_obs") = Null: CRSobj_s1x("zzz_obs") = Null: CRSobj_s1x("yyy_obs") = Null
        CRSobj_s1x("wdt_foc") = Null: CRSobj_s1x("lft_scc") = Null: CRSobj_s1x("top_scc") = Null
        
      Else
        Set CRSobj_s1x = DBSobj_s1x.OpenRecordset("s1x_fly", 2, 8)
        CRSobj_s1x.AddNew
        On Error GoTo SavInsErr
      End If

  End If
          
    
CRSobj_s1x("cnt_index") = IDXcnt_s1x
CRSobj_s1x("cmp_index") = NBRcmp%
CRSobj_s1x("fly_index") = IDXfly_s1x
CRSobj_s1x("xxx") = Null:        CRSobj_s1x("zzz") = Null
CRSobj_s1x("hgh") = Null:        CRSobj_s1x("err") = Null
CRSobj_s1x("sts") = "TL"
  
CRSobj_s1x.Update
On Error GoTo 0
          
ALTcmp_fly(CmpCtr.IDXrec, IDXfly_s1x) = 0
ERRcmp_fly(CmpCtr.IDXrec, IDXfly_s1x) = 0
STScmp_fly(CmpCtr.IDXrec, IDXfly_s1x) = "TL"
MSR_CTR.FlyTrkImg.Top = -600
MSR_CTR.FlyDsqImg.Top = 0


        '........................................................... TRACK-LOST FR ALLE PEILUNGEN SETZEN
        UPDx$ = " UPDATE s1x_msr"
UPDx$ = UPDx$ + " SET cnt_index = 0"
UPDx$ = UPDx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
UPDx$ = UPDx$ + "   AND cmp_index =" + Str(NBRcmp%)
UPDx$ = UPDx$ + "   AND fly_index =" + Str(IDXfly_s1x)
On Error GoTo SavUpdErr
DBSobj_s1x.Execute UPDx$
On Error GoTo 0
 
QRYx$ = " SELECT * FROM s1x_msr WHERE cnt_index = 0"
On Error GoTo SavAccErr
Set CRSobj_s1x = DBSobj_s1x.OpenRecordset(QRYx$, 2, 0)
On Error GoTo 0
 
  For STCi% = 1 To MsrCtr.NBRrec
    GoSub SavTrkLst
  Next STCi%

MsrCtrDrwFrame MsrCtr.IDXrec, 0
MsrCtr.IDXrec = 1: MsrCtr.NBRscr = 0
MsrCtrShwRecList
S1xFrmSetScrPointer MSR_CTR, MsrCtr.NBRrec, MsrCtr.NBRrow, MsrCtr.NBRscr
MsrCtrLodInpValue 0
MsrCtrDrwFrame MsrCtr.IDXrec, 1
  

'....................................................................... DATEN DER STATIONS-PAARE LSCHEN
  
        UPDx$ = " UPDATE s1x_clc "
UPDx$ = UPDx$ + " SET cnt_index = 0 "
UPDx$ = UPDx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
UPDx$ = UPDx$ + "  AND cmp_index =" + Str(NBRcmp%)
UPDx$ = UPDx$ + "  AND fly_index =" + Str(IDXfly_s1x)
On Error GoTo SavUpdErr
DBSobj_s1x.Execute UPDx$
On Error GoTo 0
  
CRSobj_s1x.Close
      

'............................................................................ Anzeige des FlugErgebnisses
CmpCtrShwFlyData CmpCtr.IDXrec, IDXfly_s1x

'......................................................... NEUBERECHNUNG DES BEST-WERTES DES WETTKMPFERS
ALTcmp_old& = ALTcnt_cmp(CmpCtr.IDXrec)
ClcCtrClcCmpResult CmpCtr.IDXrec
      
  
  '....................................................................... NEUBERECHNUNG DER PLAZIERUNGEN
  If ALTcnt_cmp(CmpCtr.IDXrec) <> ALTcmp_old& Then
    ClcCtrClcCmpPositions
  
      For IDXcmp% = 1 To CmpCtr.NBRrec
        CmpCtrShwCmpPosition IDXcmp%
      Next IDXcmp%
    
    CmpCtrDrwFrame CmpCtr.IDXrec, 2
  End If

If Mid(LSTfrm_opn, 4, 1) = "*" Then ClcCtrLodDuoData

                                                                                                 Exit Sub
'********************************************************************************************************
'--------------------------------------------------------------------------------------------------------
'--------------------------------------------------------------------------------------------------------
SavTrkLst:
    
ALPstc_fly(STCi%) = 0: GMAstc_fly(STCi%) = 0

RECx$ = MsrCtr.RECdat(STCi%)
P1% = InStr(RECx$, Chr(1)): P3% = InStr(P1%, RECx$, Chr(3))
RECx$ = Left(RECx$, P1%) + TL$ + Chr(2) + TL$ + Right(RECx$, Len(RECx$) - P3% + 1)
MsrCtr.RECdat(STCi%) = RECx$
    
  If QRYx$ > "" Then
      
      If Not CRSobj_s1x.EOF Then
        CRSobj_s1x.Edit
        CRSobj_s1x("cnt_index") = IDXcnt_s1x
        CRSobj_s1x("cmp_index") = NBRcmp%
        CRSobj_s1x("fly_index") = IDXfly_s1x
        CRSobj_s1x("stc_index") = STCi%
        CRSobj_s1x("hrz_angle") = Null
        CRSobj_s1x("vtc_angle") = Null
        
        On Error GoTo SavUpdErr
        CRSobj_s1x.Update
        On Error GoTo 0
        
        CRSobj_s1x.MoveNext
        Return
      
      Else
        QRYx$ = ""
        Set CRSobj_s1x = DBSobj_s1x.OpenRecordset("s1x_msr", 2, 8)
      End If
              
  End If

CRSobj_s1x.AddNew

CRSobj_s1x("cnt_index") = IDXcnt_s1x
CRSobj_s1x("cmp_index") = NBRcmp%
CRSobj_s1x("fly_index") = IDXfly_s1x
CRSobj_s1x("stc_index") = STCi%
CRSobj_s1x("hrz_angle") = Null
CRSobj_s1x("vtc_angle") = Null

On Error GoTo SavInsErr
CRSobj_s1x.Update
On Error GoTo 0
                                                                                                   Return
'--------------------------------------------------------------------------------------------------------
'--------------------------------------------------------------------------------------------------------
SavAccErr:
S1xDbsAccError 1
Resume SavInpEnd

SavUpdErr:
S1xDbsAccError 2
Resume SavInpEnd

SavInsErr:
S1xDbsAccError 3
Resume SavInpEnd

SavInpEnd:
MSR_CTR.MousePointer = 0
            
'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'*********************************** AUSGABE DER MARKIERUNGS-RAHMENS ************************************
'
  Sub MsrCtrDrwFrame(RECx%, SETx%)
'
'........................................................................................................


  If MsrCtr.IDXrec > 0 Then

      Select Case SETx%
        Case 0: CC& = COLbkc_lst
        Case 1: CC& = COLfrm_lst
      End Select
    
    X1% = 90: X2% = MSR_CTR.RecLstPct.Width - 120
    YY& = TOPspc_lst + (RECx% - MsrCtr.NBRscr - 1) * HGHrow_lst
    Y1% = YY& - 30: Y2% = YY& + HGHfrm_lst
    MSR_CTR.RecLstPct.Line (X1%, Y1%)-(X2%, Y2%), CC&, B
    If BLDfrm_lst = 1 Then MSR_CTR.RecLstPct.Line (X1% + 15, Y1% + 15)-(X2% - 15, Y2% - 15), CC&, B
  End If
  
'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'************************************** DISQUALIFIZIEREN EINES FLUGES ***********************************
'
  Sub MsrCtrSetFlyDisQualified()
'
'
' DQ: Datenbank S1X_MSR = leer, S1X_FLY = 0/0/DQ     Anzeige   /
' TL: Datenbank S1X_MSR = 0/0                        Anzeige --/--
'
'
'........................................................................................................
  

MSR_CTR.ValInpTxt.Text = " "
NBRcmp% = Val(CmpCtr.RECdat(CmpCtr.IDXrec))

'.................................................................................. EINTRAG DQ IN S1X_FLY
        
        QRYx$ = " SELECT * "
QRYx$ = QRYx$ + " FROM s1x_fly "
QRYx$ = QRYx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
QRYx$ = QRYx$ + "  AND cmp_index =" + Str(NBRcmp%)
QRYx$ = QRYx$ + "  AND fly_index =" + Str(IDXfly_s1x)
On Error GoTo SavAccErr
Set CRSobj_s1x = DBSobj_s1x.OpenRecordset(QRYx$, 2, 0)
On Error GoTo 0
    
  If Not CRSobj_s1x.EOF Then
      
      If CRSobj_s1x("sts") = "DQ" Then Exit Sub
      
    CRSobj_s1x.Edit
    On Error GoTo SavUpdErr
  Else
      
    QRYx$ = " SELECT * FROM s1x_fly WHERE cnt_index = 0"
    On Error GoTo SavAccErr
    Set CRSobj_s1x = DBSobj_s1x.OpenRecordset(QRYx$, 2, 0)
    On Error GoTo 0
  
      If Not CRSobj_s1x.EOF Then
        CRSobj_s1x.Edit
        On Error GoTo SavUpdErr
        
      Else
        Set CRSobj_s1x = DBSobj_s1x.OpenRecordset("s1x_fly", 2, 8)
        CRSobj_s1x.AddNew
        On Error GoTo SavInsErr
      End If

  End If
              
        
CRSobj_s1x("cnt_index") = IDXcnt_s1x
CRSobj_s1x("cmp_index") = NBRcmp%
CRSobj_s1x("fly_index") = IDXfly_s1x

CRSobj_s1x("xxx") = Null: CRSobj_s1x("zzz") = Null
CRSobj_s1x("hgh") = Null: CRSobj_s1x("err") = Null
CRSobj_s1x("sts") = "DQ"
    
CRSobj_s1x("xxx_obs") = Null: CRSobj_s1x("zzz_obs") = Null
CRSobj_s1x("yyy_obs") = Null: CRSobj_s1x("wdt_foc") = Null
CRSobj_s1x("lft_scc") = Null: CRSobj_s1x("top_scc") = Null
  
CRSobj_s1x.Update
On Error GoTo 0

ALTcmp_fly(CmpCtr.IDXrec, IDXfly_s1x) = 0
ERRcmp_fly(CmpCtr.IDXrec, IDXfly_s1x) = 0
STScmp_fly(CmpCtr.IDXrec, IDXfly_s1x) = "DQ"
MSR_CTR.FlyDsqImg.Top = -600
MSR_CTR.FlyTrkImg.Top = 0


'........................................................... LSCHEN ALLER EINTRGE DES FLUGES IN S1X_MSR
        
        UPDx$ = " UPDATE s1x_msr "
UPDx$ = UPDx$ + " SET cnt_index = 0 "
UPDx$ = UPDx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
UPDx$ = UPDx$ + "  AND cmp_index =" + Str(NBRcmp%)
UPDx$ = UPDx$ + "  AND fly_index =" + Str(IDXfly_s1x)
On Error GoTo SavUpdErr
DBSobj_s1x.Execute UPDx$
On Error GoTo 0

  For STCi% = 1 To MsrCtr.NBRrec
    ALPstc_fly(STCi%) = 0: GMAstc_fly(STCi%) = 0
    
    RECx$ = LTrim(Str(STCi%)): If STCi% < 10 Then RECx$ = "0" + RECx$
    RECx$ = "Number  " + RECx$ + Chr(1) + Chr(2) + Chr(3)
    MsrCtr.RECdat(STCi%) = RECx$
  Next STCi%

MsrCtrDrwFrame MsrCtr.IDXrec, 0
MsrCtr.IDXrec = 1: MsrCtr.NBRscr = 0
MsrCtrShwRecList
S1xFrmSetScrPointer MSR_CTR, MsrCtr.NBRrec, MsrCtr.NBRrow, MsrCtr.NBRscr
MsrCtrLodInpValue 0
MsrCtrDrwFrame MsrCtr.IDXrec, 1

'........................................................... LSCHEN ALLER EINTRGE DES FLUGES IN S1X_CLC

        SQLx$ = " UPDATE s1x_clc"
SQLx$ = SQLx$ + " SET cnt_index = 0"
SQLx$ = SQLx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
SQLx$ = SQLx$ + "  AND cmp_index =" + Str(NBRcmp%)
SQLx$ = SQLx$ + "  AND fly_index =" + Str(IDXfly_s1x)
On Error GoTo SavUpdErr
DBSobj_s1x.Execute SQLx$
On Error GoTo 0

CRSobj_s1x.Close

'............................................................................ Anzeige des FlugErgebnisses
CmpCtrShwFlyData CmpCtr.IDXrec, IDXfly_s1x

'......................................................... NEUBERECHNUNG DES BEST-WERTES DES WETTKMPFERS
ALTcmp_old& = ALTcnt_cmp(CmpCtr.IDXrec)
ClcCtrClcCmpResult CmpCtr.IDXrec
      
  
  '....................................................................... NEUBERECHNUNG DER PLAZIERUNGEN
  If ALTcnt_cmp(CmpCtr.IDXrec) <> ALTcmp_old& Then
    ClcCtrClcCmpPositions
  
      For IDXcmp% = 1 To CmpCtr.NBRrec
        CmpCtrShwCmpPosition IDXcmp%
      Next IDXcmp%
    
    CmpCtrDrwFrame CmpCtr.IDXrec, 2
  End If

If Mid(LSTfrm_opn, 4, 1) = "*" Then ClcCtrLodDuoData

                                                                                                 Exit Sub
'********************************************************************************************************
'--------------------------------------------------------------------------------------------------------
'--------------------------------------------------------------------------------------------------------
SavAccErr:
S1xDbsAccError 1
Resume SavInpEnd

SavUpdErr:
S1xDbsAccError 2
Resume SavInpEnd

SavInsErr:
S1xDbsAccError 3
Resume SavInpEnd

SavInpEnd:
MSR_CTR.MousePointer = 0
            
'********************************************************************************************************
                                                                                                  End Sub






'********************************************************************************************************
'************************ LADEN DER PEILUNGS-DATEN EINES FLUGES EINES WETTKMPFERS **********************
'
  Sub MsrCtrLodMsrData()
'
'        Interpretation der Daten:  Station ohne Record         = keine Werte (Empty)
'                                   Record mit NullWinkeln      = TrackLost   (- -)
'                                   Record mit einem NullWinkel = kein Werte fr den Winkel (Empty)
'
'........................................................................................................


MsrCtr.NBRrec = StcCtr.NBRrec

ReDim DATfly%(StcCtr.NBRrec), DATalp%(StcCtr.NBRrec), DATgma%(StcCtr.NBRrec) '................ DatenFlags
ReDim ALPstc_fly(StcCtr.NBRrec) As Single '................................... Horizontale PeilungsWinkel
ReDim GMAstc_fly(StcCtr.NBRrec) As Single '..................................... Vertikale PeilungsWinkel

'................................................................. StartNummer des aktuellen Wettkmpfers
Pq% = InStr(CmpCtr.RECdat(CmpCtr.IDXrec), Chr(1))
CMPnbr$ = Left(CmpCtr.RECdat(CmpCtr.IDXrec), Pq% - 1)

STSfly$ = STScmp_fly(CmpCtr.IDXrec, IDXfly_s1x)
  
  If Not (STSfly$ = "" Or STSfly$ = "DQ") Then
  
            QRYx$ = " SELECT "
    QRYx$ = QRYx$ + " stc_index, hrz_angle, vtc_angle"
    QRYx$ = QRYx$ + " FROM s1x_msr "
    QRYx$ = QRYx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
    QRYx$ = QRYx$ + "  AND cmp_index =" + CMPnbr$
    QRYx$ = QRYx$ + "  AND fly_index =" + Str(IDXfly_s1x)
    
    Set CRSobj_s1x = DBSobj_s1x.OpenRecordset(QRYx$, 2, 4)
    
      Do While Not CRSobj_s1x.EOF
        IDXstc% = CRSobj_s1x(0)
        
        DATfly%(IDXstc%) = 1
        If Not IsNull(CRSobj_s1x(1)) Then ALPstc_fly(IDXstc%) = CRSobj_s1x(1): DATalp%(IDXstc%) = 1
        If Not IsNull(CRSobj_s1x(2)) Then GMAstc_fly(IDXstc%) = CRSobj_s1x(2): DATgma%(IDXstc%) = 1
            
        CRSobj_s1x.MoveNext
      Loop
    
    CRSobj_s1x.Close
  End If
  
    
  For STCi% = 1 To StcCtr.NBRrec
    RECx$ = LTrim(Str(STCi%)): If STCi% < 10 Then RECx$ = "0" + RECx$
    RECx$ = "Number  " + RECx$ + Chr(1)
  
          
      If DATfly%(STCi%) = 1 Then
      
          If DATalp%(STCi%) <> 0 And DATgma%(STCi%) <> 0 Then '............................ PeilungsWerte
          
            ALPx$ = S1xFmtDbsValue$(Str(ALPstc_fly(STCi%)), "NBR_3,2")
            RECx$ = RECx$ + ALPx$ + Chr(2)
          
            GMAx$ = S1xFmtDbsValue$(Str(GMAstc_fly(STCi%)), "NBR_3,2")
            RECx$ = RECx$ + GMAx$ + Chr(3)
            
          Else '............................................................................... TrackLost
            RECx$ = RECx$ + "- - " + Chr(2) + "- - " + Chr(3)
          End If
      
      Else '................................................................................ Kein Eintrag
        RECx$ = RECx$ + Chr(2) + Chr(3)
      End If
      
    MsrCtr.RECdat(STCi%) = RECx$
  Next STCi%
  


MsrCtr.NBRscr = 0: MsrCtr.IDXrec = 1
IDXang_msr = 0

MsrCtrShwRecList
If MsrCtr.NBRrec > MsrCtr.NBRrow Then S1xFrmIniScrBar MSR_CTR, MsrCtr.NBRrec, MsrCtr.NBRrow, MsrCtr.NBRscr
MsrCtrLodInpValue 0


If STSfly$ = "TL" Then MSR_CTR.FlyTrkImg.Top = -600 Else MSR_CTR.FlyTrkImg.Top = 0
If STSfly$ = "DQ" Then MSR_CTR.FlyDsqImg.Top = -600 Else MSR_CTR.FlyDsqImg.Top = 0

'********************************************************************************************************
                                                                                                  End Sub



'********************************************************************************************************
'****************** ANZEIGEN DER DATEN DES AKTUELLEN WETTKMPFERS IM FORMULAR FLIGHTS *******************
'
  Sub MsrCtrSetCompetitor()
'
'........................................................................................................


P1% = InStr(CmpCtr.RECdat(CmpCtr.IDXrec), Chr(1))
P2% = InStr(CmpCtr.RECdat(CmpCtr.IDXrec), Chr(2))
P3% = InStr(CmpCtr.RECdat(CmpCtr.IDXrec), Chr(3))

NBRx$ = Left(CmpCtr.RECdat(CmpCtr.IDXrec), P1% - 1)
NAMx$ = Mid(CmpCtr.RECdat(CmpCtr.IDXrec), P1% + 1, P2% - P1% - 1)
ADDx$ = Mid(CmpCtr.RECdat(CmpCtr.IDXrec), P2% + 1, P3% - P2% - 1)

CMPtxt$ = NBRx$ + "  " + NAMx$
If ADDx$ > "" Then CMPtxt$ = CMPtxt$ + " - " + ADDx$

  
MSR_CTR.CmpPct.BackColor = MSR_CTR.BackColor
  
MSR_CTR.CmpPct.ForeColor = &HFFFFFF
MSR_CTR.CmpPct.CurrentX = 15: MSR_CTR.CmpPct.CurrentX = 15: MSR_CTR.CmpPct.Print CMPtxt$;

MSR_CTR.CmpPct.ForeColor = &H800000
MSR_CTR.CmpPct.CurrentX = 0: MSR_CTR.CmpPct.CurrentX = 0: MSR_CTR.CmpPct.Print CMPtxt$;

TXTx$ = "Measure Results of Flight" + Str(IDXfly_s1x) + " for Competitor" + Str(Val(NBRx$)) + " ..."
S1xFrmInfText MSR_CTR, TXTx$

'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'******************* SYNCHRINISIEREN DER ERGEBNIS-LISTE MIT DEM WETTKMPFER IN FLIGHTS ******************
'
  Sub MsrCtrEquCompetitor(IDXcmp_old%)
'
'........................................................................................................

  
SCRcmp_old% = CmpCtr.NBRscr

If CmpCtr.IDXrec < CmpCtr.NBRscr + 1 Then CmpCtr.NBRscr = CmpCtr.IDXrec - 1
If CmpCtr.IDXrec > CmpCtr.NBRscr + CmpCtr.NBRrow Then CmpCtr.NBRscr = CmpCtr.IDXrec - CmpCtr.NBRrow
If CmpCtr.NBRscr < 0 Then CmpCtr.NBRscr = 0

  If Mid(LSTfrm_opn, 2, 1) = "*" Then
      
      If CmpCtr.NBRscr <> SCRcmp_old% And Mid(LSTfrm_opn, 2, 1) = "*" Then
        CmpCtrShwRecList
        S1xFrmSetScrPointer CMP_CTR, CmpCtr.NBRrec, CmpCtr.NBRrow, CmpCtr.NBRscr
        CmpCtrDrwFrame CmpCtr.IDXrec, 2
      Else
        CmpCtrDrwFrame IDXcmp_old%, 0
        CmpCtrDrwFrame CmpCtr.IDXrec, 2
      End If
  
  End If
  
'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'*********************************** INITIALISIEREN DES EINGABE-BEREICHES *******************************
'
  Sub MsrCtrLodInpValue(IDXang%)
'
'........................................................................................................


TABx% = 2 + IDXang%
P1% = InStr(MsrCtr.RECdat(MsrCtr.IDXrec), Chr(TABx% - 1))
P2% = InStr(P1%, MsrCtr.RECdat(MsrCtr.IDXrec), Chr(TABx%))
VALx$ = Mid(MsrCtr.RECdat(MsrCtr.IDXrec), P1% + 1, P2% - P1% - 1)

  If VALx$ <> "- - " Then
    MSR_CTR.ValInpTxt.Text = " " + Mid(MsrCtr.RECdat(MsrCtr.IDXrec), P1% + 1, P2% - P1% - 1)
  Else
    MSR_CTR.ValInpTxt.Text = " - -"
  End If
  
LFTx% = MsrCtr.TABlst(TABx%) - MSR_CTR.ValFrmPct.Width
TOPx% = TOPspc_lst + (MsrCtr.IDXrec - MsrCtr.NBRscr - 1) * HGHrow_lst
MSR_CTR.ValFrmPct.Move LFTx%, TOPx%

MSR_CTR.ValInpTxt.SelStart = 1

IDXang_msr = IDXang%

'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'********************************** ANZEIGE DER LISTE DER PEILUNGS-DATEN ********************************
'
  Sub MsrCtrShwRecList()
'
'........................................................................................................


MSR_CTR.RecLstPct.ForeColor = COLrec_lst
MSR_CTR.RecLstPct.FontBold = BLDrec_lst


X1% = 150: X2% = MSR_CTR.RecLstPct.Width - 120
DY% = TOPspc_lst - HGHrow_lst

  If MSR_CTR.RecLstPct.AutoRedraw = 0 Then
    
      For ROWi% = 1 To MsrCtr.NBRrow
        RECx% = ROWi% + MsrCtr.NBRscr
    
        YY& = DY% + ROWi% * HGHrow_lst
        Y1% = YY& - 30: Y2% = YY& + HGHfrm_lst
        MSR_CTR.RecLstPct.Line (X1%, Y1%)-(X2%, Y2%), COLbkc_lst, BF
          If RECx% > MsrCtr.NBRrec Then Exit For
    
        MsrCtrShwRecord RECx%, YY&
      Next ROWi%

  Else
    MSR_CTR.RecLstPct.BackColor = COLbkc_lst
    
      For ROWi% = 1 To MsrCtr.NBRrow
        RECx% = ROWi% + MsrCtr.NBRscr
          If RECx% > MsrCtr.NBRrec Then Exit For
    
        YY& = DY% + ROWi% * HGHrow_lst
        MsrCtrShwRecord RECx%, YY&
      Next ROWi%
    
  End If
  

'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'**************************************** ANZEIGE EINES RECORDS *****************************************
'
  Sub MsrCtrShwRecord(RECx%, YY&)
'
'........................................................................................................
      
MSR_CTR.RecLstPct.CurrentY = YY&

CLMi% = 1: P2% = InStr(MsrCtr.RECdat(RECx%), Chr(CLMi%))
VALx$ = Mid(MsrCtr.RECdat(RECx%), 1, P2% - 1)
MSR_CTR.RecLstPct.CurrentX = MsrCtr.TABlst(CLMi%) - MSR_CTR.RecLstPct.TextWidth(VALx$)
MSR_CTR.RecLstPct.Print VALx$;
    
  For CLMi% = 2 To 3
    P1% = P2% + 1: P2% = InStr(P1%, MsrCtr.RECdat(RECx%), Chr(CLMi%))
    VALx$ = Mid(MsrCtr.RECdat(RECx%), P1%, P2% - P1%)
    If VALx$ > "" And VALx$ <> "- - " Then VALx$ = VALx$ + ""
    MSR_CTR.RecLstPct.CurrentX = MsrCtr.TABlst(CLMi%) - MSR_CTR.RecLstPct.TextWidth(VALx$)
    MSR_CTR.RecLstPct.Print VALx$;
  Next CLMi%


'********************************************************************************************************
                                                                                                  End Sub



'********************************************************************************************************
'********************************************************************************************************
'
  Sub MsrCtrSetFlyIndex(IDXfly%)
'
'........................................................................................................
      

  For IDXi% = 1 To 3
    If IDXi% = IDXfly% Then MSR_CTR.WrkCtrImg(IDXi%).Top = -600 Else MSR_CTR.WrkCtrImg(IDXi%).Top = 0
  Next IDXi%

'********************************************************************************************************
                                                                                                  End Sub


