Attribute VB_Name = "STC_FNC"

'********************************************************************************************************
'*************************************** DRUCK DER STATIONS-DATEN ***************************************
'
  Sub StcCtrPrint()
'
'........................................................................................................

DoEvents
    
      #If Win16 Then
        If Mid(LSTfrm_opn, 4, 1) = "*" Then Unload CLC_CTR
        If Mid(LSTfrm_opn, 3, 1) = "*" Then Unload MSR_CTR
        DoEvents
      #End If
  
  

'...................................................................................... WETTBEWERBS-DATEN
On Error GoTo PrnErr

Printer.KillDoc
Printer.EndDoc

  If StcCtr.NBRrec < 7 Then
    Printer.Orientation = 1
  Else
    Printer.Orientation = 2
  End If
  
Printer.FontName = "Arial"
Printer.FontBold = 0
Printer.FontTransparent = 0
Printer.ColorMode = 1

BRDpgs% = 1200
WDTpgs% = Printer.Width - 2 * BRDpgs%

TOPx% = 750

        
        QRYx$ = " SELECT titel, location, date, director, jury FROM s1x_cnt"
QRYx$ = QRYx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
Set CRSobj_s1x = DBSobj_s1x.OpenRecordset(QRYx$, 2, 4)

If Not IsNull(CRSobj_s1x(0)) Then TTLx$ = CRSobj_s1x(0)
If Not IsNull(CRSobj_s1x(1)) Then ORTx$ = CRSobj_s1x(1)
If Not IsNull(CRSobj_s1x(2)) Then DTMx$ = CRSobj_s1x(2)
If Not IsNull(CRSobj_s1x(3)) Then DRCx$ = CRSobj_s1x(3)
If Not IsNull(CRSobj_s1x(4)) Then JRYx$ = CRSobj_s1x(4)
CRSobj_s1x.Close

  
LOCx$ = ORTx$
If DTMx$ > "" Then LOCx$ = LOCx$ + ", " + DTMx$

'................................................................................................... Kopf
Printer.FontSize = 16
Printer.CurrentX = BRDpgs% + 0.5 * (WDTpgs% - Printer.TextWidth(TTLx$))
Printer.CurrentY = TOPx%: Printer.Print TTLx$;
TOPx% = TOPx% + 540

Printer.FontSize = 12
Printer.CurrentX = BRDpgs% + 0.5 * (WDTpgs% - Printer.TextWidth(LOCx$))
Printer.CurrentY = TOPx%: Printer.Print LOCx$;

TOPx% = TOPx% + 900

'......................................................................................... STATIONS-DATEN

'...................................................................................... SpaltenPositionen
Printer.FontSize = 10
Printer.FontBold = 0
  
  If LCDlng_s1x = "GER" Then
    TXTx$ = "Winkel zur rechten NachbarStation"
  Else
    TXTx$ = "Vertical LauncheAngle"
  End If
  
WDTcpt% = Printer.TextWidth(TXTx$) + 300
WDTclm% = (WDTpgs% - WDTcpt%) / StcCtr.NBRrec

TXTspc% = 150
DY% = Printer.TextHeight("")

TBLbgn% = TOPx%


'..................................................................................... StationsBezeichner
TXTx$ = "Station"
WDTtxt% = Printer.TextWidth(TXTx$)

  For STCi% = 1 To StcCtr.NBRrec
    Printer.CurrentX = BRDpgs% + WDTcpt% + (STCi% - 1) * WDTclm% + 0.5 * (WDTclm% - WDTtxt%)
    Printer.CurrentY = TOPx%: Printer.Print TXTx$;
  Next STCi%

TOPx% = TOPx% + DY%
  
  For STCi% = 1 To StcCtr.NBRrec
    TXTx$ = LTrim(Str(STCi%)): WDTtxt% = Printer.TextWidth(TXTx$)
    Printer.CurrentX = BRDpgs% + WDTcpt% + (STCi% - 1) * WDTclm% + 0.5 * (WDTclm% - WDTtxt%)
    Printer.CurrentY = TOPx%: Printer.Print TXTx$;
  Next STCi%
  
TOPx% = TOPx% + 2 * DY%
  
'..................................................................................... WinkelDefinitionen
If LCDlng_s1x = "GER" Then CPTx$ = "Horizontaler rechter Winkel" Else CPTx$ = "Horizontal Rectangle"
Printer.CurrentX = BRDpgs% + WDTcpt% - Printer.TextWidth(CPTx$) - TXTspc%
Printer.CurrentY = TOPx%: Printer.Print CPTx$;

  For STCi% = 1 To StcCtr.NBRrec
    TXTx$ = LTrim(Str(RCTstc_hrz(STCi%))) + " ": WDTtxt% = Printer.TextWidth(TXTx$)
    Printer.CurrentX = BRDpgs% + WDTcpt% + STCi% * WDTclm% - WDTtxt% - TXTspc%
    Printer.CurrentY = TOPx%: Printer.Print TXTx$;
  Next STCi%

TOPx% = TOPx% + DY%

If LCDlng_s1x = "GER" Then CPTx$ = "Vertikaler rechter Winkel" Else CPTx$ = "Vertical Rectangle"
Printer.CurrentX = BRDpgs% + WDTcpt% - Printer.TextWidth(CPTx$) - TXTspc%
Printer.CurrentY = TOPx%: Printer.Print CPTx$;

  For STCi% = 1 To StcCtr.NBRrec
    TXTx$ = LTrim(Str(RCTstc_vtc(STCi%))) + " ": WDTtxt% = Printer.TextWidth(TXTx$)
    Printer.CurrentX = BRDpgs% + WDTcpt% + STCi% * WDTclm% - WDTtxt% - TXTspc%
    Printer.CurrentY = TOPx%: Printer.Print TXTx$;
  Next STCi%

TOPx% = TOPx% + 2 * DY%

'....................................................................................... MeGenauigkeiten
If LCDlng_s1x = "GER" Then CPTx$ = "Horizontale MeGenauigkeit" Else CPTx$ = "Horizontal Accuracy"
Printer.CurrentX = BRDpgs% + WDTcpt% - Printer.TextWidth(CPTx$) - TXTspc%
Printer.CurrentY = TOPx%: Printer.Print CPTx$;

  For STCi% = 1 To StcCtr.NBRrec
    TXTx$ = S1xFmtInpValue$(Str(PRCstc_hrz(STCi%)), "NBR_1,2") + " "
    WDTtxt% = Printer.TextWidth(TXTx$)
    
    Printer.CurrentX = BRDpgs% + WDTcpt% + STCi% * WDTclm% - WDTtxt% - TXTspc%
    Printer.CurrentY = TOPx%: Printer.Print TXTx$;
  Next STCi%

TOPx% = TOPx% + DY%

If LCDlng_s1x = "GER" Then CPTx$ = "Vertikale MeGenauigkeit" Else CPTx$ = "Vertical Accuracy"
Printer.CurrentX = BRDpgs% + WDTcpt% - Printer.TextWidth(CPTx$) - TXTspc%
Printer.CurrentY = TOPx%: Printer.Print CPTx$;

  For STCi% = 1 To StcCtr.NBRrec
    TXTx$ = S1xFmtInpValue$(Str(PRCstc_vtc(STCi%)), "NBR_1,2") + " "
    WDTtxt% = Printer.TextWidth(TXTx$)
    
    Printer.CurrentX = BRDpgs% + WDTcpt% + STCi% * WDTclm% - WDTtxt% - TXTspc%
    Printer.CurrentY = TOPx%: Printer.Print TXTx$;
  Next STCi%

TOPx% = TOPx% + 2 * DY%


'.......................................................................... Daten der PositionsBestimmung
If LCDlng_s1x = "GER" Then CPTx$ = "Winkel zur linken NachbarStation" Else CPTx$ = "LeftStationAngle"
Printer.CurrentX = BRDpgs% + WDTcpt% - Printer.TextWidth(CPTx$) - TXTspc%
Printer.CurrentY = TOPx%: Printer.Print CPTx$;

  For STCi% = 1 To StcCtr.NBRrec
    TXTx$ = S1xFmtInpValue$(Str(ALPstc_lnc(STCi%)), "NBR_3,2") + " "
    WDTtxt% = Printer.TextWidth(TXTx$)
    
    Printer.CurrentX = BRDpgs% + WDTcpt% + STCi% * WDTclm% - WDTtxt% - TXTspc%
    Printer.CurrentY = TOPx%: Printer.Print TXTx$;
  Next STCi%

TOPx% = TOPx% + DY%

If LCDlng_s1x = "GER" Then CPTx$ = "Winkel zur rechten NachbarStation" Else CPTx$ = "RightStationAngle"
Printer.CurrentX = BRDpgs% + WDTcpt% - Printer.TextWidth(CPTx$) - TXTspc%
Printer.CurrentY = TOPx%: Printer.Print CPTx$;

  For STCi% = 1 To StcCtr.NBRrec
    TXTx$ = S1xFmtInpValue$(Str(BTAstc_lnc(STCi%)), "NBR_3,2") + " "
    WDTtxt% = Printer.TextWidth(TXTx$)
    
    Printer.CurrentX = BRDpgs% + WDTcpt% + STCi% * WDTclm% - WDTtxt% - TXTspc%
    Printer.CurrentY = TOPx%: Printer.Print TXTx$;
  Next STCi%

TOPx% = TOPx% + DY%

If LCDlng_s1x = "GER" Then CPTx$ = "VertikalWinkel zur StartStelle" Else CPTx$ = "Vertical LauncheAngle"
Printer.CurrentX = BRDpgs% + WDTcpt% - Printer.TextWidth(CPTx$) - TXTspc%
Printer.CurrentY = TOPx%: Printer.Print CPTx$;

  For STCi% = 1 To StcCtr.NBRrec
    TXTx$ = S1xFmtInpValue$(Str(GMAstc_lnc(STCi%)), "NBR_3,2") + " "
    WDTtxt% = Printer.TextWidth(TXTx$)
    
    Printer.CurrentX = BRDpgs% + WDTcpt% + STCi% * WDTclm% - WDTtxt% - TXTspc%
    Printer.CurrentY = TOPx%: Printer.Print TXTx$;
  Next STCi%

TOPx% = TOPx% + DY%

If LCDlng_s1x = "GER" Then CPTx$ = "Entfernung zur StartStelle" Else CPTx$ = "LauncheDistance"
Printer.CurrentX = BRDpgs% + WDTcpt% - Printer.TextWidth(CPTx$) - TXTspc%
Printer.CurrentY = TOPx%: Printer.Print CPTx$;

  For STCi% = 1 To StcCtr.NBRrec
    TXTx$ = S1xFmtInpValue$(Str(DSTstc_lnc(STCi%)), "NBR_4,2") + " m"
    WDTtxt% = Printer.TextWidth(TXTx$)
    
    Printer.CurrentX = BRDpgs% + WDTcpt% + STCi% * WDTclm% - WDTtxt% - TXTspc%
    Printer.CurrentY = TOPx%: Printer.Print TXTx$;
  Next STCi%

TOPx% = TOPx% + 2 * DY%


'..................................................................................... StationsPositionen
If LCDlng_s1x = "GER" Then CPTx$ = "X-Koordinate" Else CPTx$ = "X-Co-ordinate"
Printer.CurrentX = BRDpgs% + WDTcpt% - Printer.TextWidth(CPTx$) - TXTspc%
Printer.CurrentY = TOPx%: Printer.Print CPTx$;

  For STCi% = 1 To StcCtr.NBRrec
    TXTx$ = LTrim(Str(Int(100 * XXXstc_loc(STCi%)))): If TXTx$ = "0" Then TXTx$ = "000"
    If LCDlng_s1x = "GER" Then QQ$ = "," Else QQ$ = "."
    TXTx$ = Left(TXTx$, Len(TXTx$) - 2) + QQ$ + Right(TXTx$, 2) + " m"
    WDTtxt% = Printer.TextWidth(TXTx$)
    Printer.CurrentX = BRDpgs% + WDTcpt% + STCi% * WDTclm% - WDTtxt% - TXTspc%
    Printer.CurrentY = TOPx%: Printer.Print TXTx$;
  Next STCi%

TOPx% = TOPx% + DY%

If LCDlng_s1x = "GER" Then CPTx$ = "Z-Koordinate" Else CPTx$ = "Z-Co-ordinate"
Printer.CurrentX = BRDpgs% + WDTcpt% - Printer.TextWidth(CPTx$) - TXTspc%
Printer.CurrentY = TOPx%: Printer.Print CPTx$;

  For STCi% = 1 To StcCtr.NBRrec
    TXTx$ = LTrim(Str(Int(100 * ZZZstc_loc(STCi%)))): If TXTx$ = "0" Then TXTx$ = "000"
    If LCDlng_s1x = "GER" Then QQ$ = "," Else QQ$ = "."
    TXTx$ = Left(TXTx$, Len(TXTx$) - 2) + QQ$ + Right(TXTx$, 2) + " m"
    WDTtxt% = Printer.TextWidth(TXTx$)
    Printer.CurrentX = BRDpgs% + WDTcpt% + STCi% * WDTclm% - WDTtxt% - TXTspc%
    Printer.CurrentY = TOPx%: Printer.Print TXTx$;
  Next STCi%

TOPx% = TOPx% + DY%

If LCDlng_s1x = "GER" Then CPTx$ = "Y-Koordinate" Else CPTx$ = "Y-Co-ordinate"
Printer.CurrentX = BRDpgs% + WDTcpt% - Printer.TextWidth(CPTx$) - TXTspc%
Printer.CurrentY = TOPx%: Printer.Print CPTx$;

  For STCi% = 1 To StcCtr.NBRrec
    TXTx$ = LTrim(Str(Int(100 * YYYstc_loc(STCi%)))): If TXTx$ = "0" Then TXTx$ = "000"
    If LCDlng_s1x = "GER" Then QQ$ = "," Else QQ$ = "."
    TXTx$ = Left(TXTx$, Len(TXTx$) - 2) + QQ$ + Right(TXTx$, 2) + " m"
    WDTtxt% = Printer.TextWidth(TXTx$)
    Printer.CurrentX = BRDpgs% + WDTcpt% + STCi% * WDTclm% - WDTtxt% - TXTspc%
    Printer.CurrentY = TOPx%: Printer.Print TXTx$;
  Next STCi%


'...................................................................................... TabellenBerahmung
TBLend% = TBLbgn% + 18 * DY%
Printer.DrawWidth = 1

X1% = BRDpgs% + WDTcpt%: Xn% = X1% + StcCtr.NBRrec * WDTclm%
Y0% = TBLbgn% - 0.5 * DY%: Yn% = TBLend% - 0.5 * DY%
                                                                                    '          _________
Printer.Line (X1% + 15, Y0% + 15)-(Xn% - 15, Yn% - 15), 0, B                        '    .....|.........|
Printer.Line (X1% - 15, Y0% - 15)-(Xn% + 15, Yn% + 15), 0, B                        '    .....|_________|

X0% = BRDpgs%: Y1% = Y0% + 3 * DY%                                                  '         ...........
Printer.Line (X0% + 15, Y1% + 15)-(Xn% - 15, Y1% + 15)                              '    _____:__________
Printer.Line (X0% - 15, Y1% - 15)-(Xn% - 15, Y1% - 15)                              '    ................
Printer.Line (X1% - 15, Y1% - 15)-(X1% + 15, Y1% + 15), &HFFFFFF, B
Printer.Line (Xn% - 15, Y1% - 15)-(Xn% - 15, Y1% + 15), &HFFFFFF
                                              
                                                                                    '         ...........
Printer.Line (X0% + 15, Y1% + 15)-(X0% + 15, Yn% - 15)                              '    .....:..........
Printer.Line (X0% - 15, Y1% - 15)-(X0% - 15, Yn% + 15)                              '    |...............

                                                                                    '         ...........
Printer.Line (X0% + 15, Yn% - 15)-(X1% + 15, Yn% - 15)                              '    .....:..........
Printer.Line (X0% - 15, Yn% + 15)-(X1% - 15, Yn% + 15)                              '    _____...........
Printer.Line (X1% - 15, Yn% - 15)-(X1% - 15, Yn% + 15), &HFFFFFF
Printer.Line (X1% - 15, Yn% - 15)-(X1% + 15, Yn% - 15), &HFFFFFF


YY% = Y1% + 3 * DY%                                                                 '    ________________
Printer.Line (X0% + 15, YY%)-(Xn% - 15, YY%)
Printer.Line (X1% - 15, YY%)-(X1% + 15, YY%), &HFFFFFF

YY% = YY% + 3 * DY%                                                                 '    ________________
Printer.Line (X0% + 15, YY%)-(Xn% - 15, YY%)
Printer.Line (X1% - 15, YY%)-(X1% + 15, YY%), &HFFFFFF

YY% = YY% + 5 * DY%                                                                 '    ________________
Printer.Line (X0% + 15, YY%)-(Xn% - 15, YY%)
Printer.Line (X1% - 15, YY%)-(X1% + 15, YY%), &HFFFFFF
 
  
  For STCi% = 1 To StcCtr.NBRrec - 1                                                '             |  |  |
    XX% = X1% + STCi% * WDTclm%
    Printer.Line (XX%, Y0% + 15)-(XX%, Yn% - 15)
    Printer.Line (XX%, Y1% - 15)-(XX%, Y1% + 15), &HFFFFFF
  Next STCi%


'..................................................................................... STATIONS-ANORDNUNG

'............................................................................. ExtremPunkte der Abbildung
LFTmin& = -9999: RGTmax& = 9999
TOPmin& = 9999: BTMmax& = -9999

  For STCi% = 0 To StcCtr.NBRrec
    If XXXstc_loc(STCi%) < TOPmin& Then TOPmin& = XXXstc_loc(STCi%)
    If XXXstc_loc(STCi%) > BTMmax& Then BTMmax& = XXXstc_loc(STCi%)
    If ZZZstc_loc(STCi%) < RGTmax& Then RGTmax& = ZZZstc_loc(STCi%)
    If ZZZstc_loc(STCi%) > LFTmin& Then LFTmin& = ZZZstc_loc(STCi%)
  Next STCi%

WDTlok& = Abs(LFTmin& - RGTmax&)
HGHlok& = Abs(BTMmax& - TOPmin&)

  If WDTlok& > HGHlok& Then
    KKK# = (WDTpgs% - 600) / WDTlok&
    LFTlnc% = BRDpgs% + 600 + KKK# * LFTmin&
    TOPlnc% = TBLend% + 600 + 0.5 * (Printer.Height - 2400 - TBLend% - KKK# * HGHlok&) - KKK# * TOPmin&
  Else
    KKK# = (Printer.Height - 3000 - TBLend%) / HGHlok&
    LFTlnc% = BRDpgs% + 600 + 0.5 * (WDTpgs% - 600 - KKK# * WDTlok&) + KKK# * LFTmin&
    TOPlnc% = TBLend% + 450 - KKK# * TOPmin&
  End If

'Printer.KillDoc: Exit Sub

'...................................................................................... KoordinatenAchsen
Printer.DrawWidth = 3
Printer.FontBold = 0

Printer.Line (BRDpgs%, TOPlnc%)-(BRDpgs% + WDTpgs%, TOPlnc%)
Printer.Line (BRDpgs%, TOPlnc%)-(BRDpgs% + 150, TOPlnc% - 30)
Printer.Line (BRDpgs%, TOPlnc%)-(BRDpgs% + 150, TOPlnc% + 30)

Printer.CurrentX = BRDpgs% + 210
Printer.CurrentY = TOPlnc% + 90
Printer.Print "Z";

Printer.Line (LFTlnc%, TBLend% + 300)-(LFTlnc%, Printer.Height - 1800)
Printer.Line (LFTlnc%, Printer.Height - 1800)-(LFTlnc% - 30, Printer.Height - 1950)
Printer.Line (LFTlnc%, Printer.Height - 1800)-(LFTlnc% + 30, Printer.Height - 1950)

LFTstc% = LFTlnc% - KKK# * ZZZstc_loc(1): TOPstc% = TOPlnc% + KKK# * XXXstc_loc(1)
Printer.Line (LFTstc% - 90, TOPstc%)-(LFTstc% + 90, TOPstc%), &HFFFFFF

Printer.CurrentX = LFTlnc% + 90
Printer.CurrentY = Printer.Height - 2190
Printer.Print "X";


'.............................................................................................. Stationen
Printer.DrawWidth = 1
Printer.FontBold = 0
WW% = 45
  
  For STCi% = 1 To StcCtr.NBRrec
    LFTstc% = LFTlnc% - KKK# * ZZZstc_loc(STCi%): TOPstc% = TOPlnc% + KKK# * XXXstc_loc(STCi%)
    
    '........................................................................................... Position
    Printer.DrawStyle = 0
    Printer.Line (LFTstc% - WW%, TOPstc% - WW%)-(LFTstc% + WW%, TOPstc% + WW%), 0, B
    Printer.Line (LFTstc% - WW% + 15, TOPstc% - WW% + 15)-(LFTstc% + WW% - 15, TOPstc% + WW% - 15), 0, BF
    
    '...................................................................... AbstandsLinie zur StartStelle
    Printer.DrawStyle = 1
    Printer.Line (LFTstc%, TOPstc%)-(LFTlnc%, TOPlnc%)
    
    
    '................................................................................. StationsBezeichner
    TXTx$ = "Station" + Str(STCi%)
          
      If Printer.Orientation = 1 Then
      
          If LFTstc% < LFTlnc% Then
            XX% = LFTstc% + 150
          Else
            XX% = LFTstc% - 150 - Printer.TextWidth(TXTx$)
          End If
      
      Else
      
          If LFTstc% < LFTlnc% Then
            XX% = LFTstc% - 150 - Printer.TextWidth(TXTx$)
          Else
            XX% = LFTstc% + 150
          End If
      
      End If
      
      
      If TOPstc% < TOPlnc% Then
        YY% = TOPstc% + 90
      Else
        YY% = TOPstc% - 300
      End If
    
    Printer.CurrentX = XX% + 15: Printer.CurrentY = YY% + 15: Printer.Print TXTx$;
  Next STCi%

'............................................................................................ StartStelle
Printer.DrawWidth = 1
Printer.DrawStyle = 0
Printer.FontBold = 0
WW% = 60

Printer.Line (LFTlnc% - WW%, TOPlnc% - WW%)-(LFTlnc% + WW%, TOPlnc% + WW%), 0, BF
Printer.Line (LFTlnc% - WW% - 30, TOPlnc% - WW% - 30)-(LFTlnc% + WW% + 30, TOPlnc% + WW% + 30), 0, B

Printer.CurrentX = LFTlnc% + 120
Printer.CurrentY = TOPlnc% + 120
Printer.Print "Launching Position";


    
'............................................................................................... Signatur
Printer.FontSize = 6
TXTx$ = "S1X    FAI/DAeC  M. Schneider 1998-1999"
Printer.CurrentX = 900: Printer.CurrentY = Printer.Height - 1200: Printer.Print TXTx$;
    
Printer.EndDoc

On Error GoTo 0
  
                                                                                                 Exit Sub
'********************************************************************************************************
'--------------------------------------------------------------------------------------------------------
PrnErr:

  If LCDlng_s1x = "GER" Then
    TXTmsg_stp = "- Der Drucker reagiert nicht -"
  Else
    TXTmsg_stp = "- No Response from Printer -"
  End If

                                                                                            Resume PrnEnd
'--------------------------------------------------------------------------------------------------------
PrnEnd:

'--------------------------------------------------------------------------------------------------------
'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'********************************************************************************************************
'
  Sub StcCtrLodStcData()
'
'........................................................................................................

        
        QRYx$ = " SELECT "
QRYx$ = QRYx$ + " stc_index, stc_typ,"
QRYx$ = QRYx$ + " hrz_rct, hrz_prc,"
QRYx$ = QRYx$ + " vtc_rct, vtc_prc,"
QRYx$ = QRYx$ + " lft_stc, rgt_stc,"
QRYx$ = QRYx$ + " vtc_lnc, dst_lnc"
QRYx$ = QRYx$ + " FROM s1x_stc WHERE cnt_index =" + Str(IDXcnt_s1x)
QRYx$ = QRYx$ + " ORDER BY stc_index"

Set CRSobj_s1x = DBSobj_s1x.OpenRecordset(QRYx$, 2, 4)

      If CRSobj_s1x.EOF Then
        StcCtr.NBRrec = 0: StcCtr.IDXrec = 0: StcCtr.NBRscr = 0
        ERRomg_grd = 0
        
          If Mid(LSTfrm_opn, 1, 1) = "*" Then
            STC_CTR.RecLstPct.Enabled = 0
            STC_CTR.RecLstPct.BackColor = &H808080
            STC_CTR.ScrBarPct.Visible = 0
            StcCtrSetErrOmega
          End If
      
        Exit Sub
      End If
  

CRSobj_s1x.MoveLast
StcCtr.NBRrec = CRSobj_s1x.RecordCount
CRSobj_s1x.MoveFirst

  For STCi% = 1 To StcCtr.NBRrec
    StcCtr.RECdat(STCi%) = StcCtrFmtRecord$(STCi%)
    CRSobj_s1x.MoveNext
  Next STCi%

CRSobj_s1x.Close



ERRomg_grd = 0
If StcCtr.NBRrec > 1 Then StcCtrClcLocation
StcCtr.NBRscr = 0: StcCtr.IDXrec = 1
  
  If Mid(LSTfrm_opn, 1, 1) = "*" Then
    StcCtrShwRecList
    S1xFrmIniScrBar STC_CTR, StcCtr.NBRrec, StcCtr.NBRrow, StcCtr.NBRscr
    StcCtrSetErrOmega
    STC_CTR.RecLstPct.Enabled = 1
  End If
  

'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'********************************************************************************************************
'
  Sub StcCtrGetWarnings()
'
'........................................................................................................

  
    If StcCtr.NBRrec < 2 Then Exit Sub
    
  '.............................................................................. Differenz zum VollKreis
  If Abs(ERRomg_grd) > 10 Then

      VALtxt$ = Str(Abs(ERRomg_grd)) + ""

      If LCDlng_s1x = "GER" Then
        TXTmsg_stp = "Die Differenz der horizontalen Peilungen der MeStationen zum VollKreis"
        TXTmsg_stp = TXTmsg_stp + " lt keine korrekten Berechnungen zu. Die PeilungsWinkel"
        TXTmsg_stp = TXTmsg_stp + " sollten berprft werden. Gegebenenfalls mssen die Peilungen"
        TXTmsg_stp = TXTmsg_stp + " wiederholt werden."
      Else
        TXTmsg_stp = "The Difference between the horizontal DirectionAngles of MeasuringStations"
        TXTmsg_stp = TXTmsg_stp + " and 360 must be smaller then 10. Otherwise the Calculations"
        TXTmsg_stp = TXTmsg_stp + " for Altitudes will be invalid. Please verify your Data and"
        TXTmsg_stp = TXTmsg_stp + " repeat measure if neccesary."
      End If
      
    Exit Sub
  End If
  
  '................................................................... Abstnde zwischen den MeStationen
  If LSTdst_err > "" Then
  
    TXTlst$ = Left(LSTdst_err, Len(LSTdst_err) - 1)
    
    Pq% = InStr(TXTlst$, ",")
    Pqq% = 0
    
      Do While Pq% > 0
        Pqq% = Pq%: Pq% = InStr(Pq% + 1, TXTlst$, ",")
      Loop
      
      
      If LCDlng_s1x = "GER" Then
        
          If Pqq% > 0 Then
            TXTlst$ = Left(TXTlst$, Pqq% - 1) + " und" + Right(TXTlst$, Len(TXTlst$) - Pqq%)
            PLRx% = 1
          End If
        
        TXTmsg_stp = "Die Abstnde zwischen den MeStationen"
        TXTmsg_stp = TXTmsg_stp + " " + TXTlst$ + "  sind geringer als 10 m. Die Berechnungen fr diese"
        TXTmsg_stp = TXTmsg_stp + " StationsPaare werden dadurch ungenau."
      Else
          
          If Pqq% > 0 Then
            TXTlst$ = Left(TXTlst$, Pqq% - 1) + " and" + Right(TXTlst$, Len(TXTlst$) - Pqq%)
            PLRx% = 1
          End If
        
        TXTmsg_stp = "Distance between MeasuringStations"
        TXTmsg_stp = TXTmsg_stp + " " + TXTlst$ + "  are less then 10 m. Calculations for this"
        TXTmsg_stp = TXTmsg_stp + " StationPairs will be extremly inaccurate."
      End If
    
    TXTmsg_stp = TXTmsg_stp + "."
    Exit Sub
  End If
  
  '.................................................................................. PeilungsDifferenzen
  If LSTstc_err > "" Then
  
    TXTlst$ = Left(LSTstc_err, Len(LSTstc_err) - 1)
    
    Pq% = InStr(TXTlst$, ",")
    Pqq% = 0
    
      Do While Pq% > 0
        Pqq% = Pq%: Pq% = InStr(Pq% + 1, TXTlst$, ",")
      Loop
      
      
      If LCDlng_s1x = "GER" Then
        
          If Pqq% > 0 Then
            TXTlst$ = Left(TXTlst$, Pqq% - 1) + " und" + Right(TXTlst$, Len(TXTlst$) - Pqq%)
            PLRx% = 1
          End If
        
        TXTmsg_stp = "Fr die MeStation"
        If PLRx% = 1 Then TXTmsg_stp = TXTmsg_stp + "en"
        TXTmsg_stp = TXTmsg_stp + " " + TXTlst$ + "  ist die Abweichung zwischen der angepeilten"
        TXTmsg_stp = TXTmsg_stp + " und der berechneten Position nicht akzeptabel"
      Else
          
          If Pqq% > 0 Then
            TXTlst$ = Left(TXTlst$, Pqq% - 1) + " and" + Right(TXTlst$, Len(TXTlst$) - Pqq%)
            PLRx% = 1
          End If
        
        TXTmsg_stp = "DirectionAngles for MeasuringStation"
        If PLRx% = 1 Then TXTmsg_stp = TXTmsg_stp + "s"
        TXTmsg_stp = TXTmsg_stp + " " + TXTlst$ + "  have Trouble with the Calculated Position"
        If PLRx% = 1 Then TXTmsg_stp = TXTmsg_stp + "s"
      End If
    
    TXTmsg_stp = TXTmsg_stp + "."
    Exit Sub
  End If


'********************************************************************************************************
                                                                                                  End Sub


'========================================================================================================
'========================== FORMATIEREN EINES RECORDS DER LISTE DER MESS-STATIONEN ======================
'
  Function StcCtrFmtRecord$(STCi%)
'
'
'       SELECT stc_index, stc_typ, hrz_rct, hrz_prc, vtc_rct, vtc_prc, lft_stc, rgt_stc, vtc_lnc, dst_lnc
'
'........................................................................................................

        
'.................................................................................................. Index
VALx$ = LTrim(Str(CRSobj_s1x(0))): If CRSobj_s1x(0) < 10 Then VALx$ = "0" + VALx$
RECx$ = VALx$ + Chr(1)

'........................................................................................ TypenBezeichner
RECx$ = RECx$ + CRSobj_s1x(1) + Chr(2)

'......................................................................... Werte rechter HorizontalWinkel
RCTstc_hrz(STCi%) = CRSobj_s1x(2): VALx$ = LTrim(Str(CRSobj_s1x(2)))
RECx$ = RECx$ + VALx$ + Chr(3)

'................................................................... Genauigkeit der horizontalen Messung
PRCstc_hrz(STCi%) = CRSobj_s1x(3): VALx$ = S1xFmtDbsValue$(Str(CRSobj_s1x(3)), "NBR_4,2")
RECx$ = RECx$ + VALx$ + Chr(4)

'........................................................................... Werte rechter VertikalWinkel
RCTstc_vtc(STCi%) = CRSobj_s1x(4): VALx$ = LTrim(Str(CRSobj_s1x(4)))
RECx$ = RECx$ + VALx$ + Chr(5)

'..................................................................... Genauigkeit der vertikalen Messung
PRCstc_vtc(STCi%) = CRSobj_s1x(5): VALx$ = S1xFmtDbsValue$(Str(CRSobj_s1x(5)), "NBR_4,2")
RECx$ = RECx$ + VALx$ + Chr(6)

'.................................................. Winkel zwischen StartStelle und vorheriger MeStation
ALPstc_lnc(STCi%) = CRSobj_s1x(6): VALx$ = S1xFmtDbsValue$(Str(CRSobj_s1x(6)), "NBR_4,2")
RECx$ = RECx$ + VALx$ + Chr(7)

'.................................................... Winkel zwischen StartStelle und nchster MeStation
BTAstc_lnc(STCi%) = CRSobj_s1x(7): VALx$ = S1xFmtDbsValue$(Str(CRSobj_s1x(7)), "NBR_4,2")
RECx$ = RECx$ + VALx$ + Chr(8)

'..................................................... VertikalWinkel zwischen MeStation und StartStelle
GMAstc_lnc(STCi%) = CRSobj_s1x(8): VALx$ = S1xFmtDbsValue$(Str(CRSobj_s1x(8)), "NBR_4,2")
RECx$ = RECx$ + VALx$ + Chr(9)

'................................................ Gemessene Abstnde der MeStationen zur StartStelle  [m]
DSTstc_lnc(STCi%) = CRSobj_s1x(9): VALx$ = S1xFmtDbsValue$(Str(CRSobj_s1x(9)), "NBR_4,2")
RECx$ = RECx$ + VALx$ + Chr(10)
      

StcCtrFmtRecord$ = RECx$

'========================================================================================================
                                                                                             End Function

'********************************************************************************************************
'***************************** SETZEN DES WERTES DES FEHLERS ZUM VOLL-KREIS *****************************
'
  Sub StcCtrSetErrOmega()
'
'........................................................................................................


    If StcCtr.NBRrec < 2 Then
      CC& = 0
    Else
    
      VALtxt$ = Str(Abs(ERRomg_grd))
      
        Select Case ERRomg_grd
          Case Is > 0: VALtxt$ = "+" + VALtxt$ + ""
          Case Is < 0: VALtxt$ = "-" + VALtxt$ + ""
          Case Is = 0: VALtxt$ = "" + VALtxt$ + ""
        End Select
        
        
        Select Case Abs(ERRomg_grd)
          Case Is < 5: CC& = &H8000&
          Case Is < 10: CC& = &H800080
          Case Else: CC& = &HFF&
        End Select
    
    End If
  
VALtxt$ = "Total Horizontal Error:  " + VALtxt$
  
STC_CTR.ErrOmgPct.BackColor = STC_CTR.BackColor
  
STC_CTR.ErrOmgPct.ForeColor = &HFFFFFF
STC_CTR.ErrOmgPct.CurrentX = 15: STC_CTR.ErrOmgPct.CurrentX = 15: STC_CTR.ErrOmgPct.Print VALtxt$;

STC_CTR.ErrOmgPct.ForeColor = CC&
STC_CTR.ErrOmgPct.CurrentX = 0: STC_CTR.ErrOmgPct.CurrentX = 0: STC_CTR.ErrOmgPct.Print VALtxt$;

  
'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'********************************* ANZEIGE DER LISTE DER STATIONS-DATEN *********************************
'
  Sub StcCtrShwRecList()
'
'........................................................................................................


STC_CTR.RecLstPct.ForeColor = COLrec_lst
STC_CTR.RecLstPct.FontBold = BLDrec_lst


X1% = 150: X2% = STC_CTR.RecLstPct.Width - 120
DY% = TOPspc_lst - HGHrow_lst

  If STC_CTR.RecLstPct.AutoRedraw = 0 Then
    
      For ROWi% = 1 To StcCtr.NBRrow
        RECx% = ROWi% + StcCtr.NBRscr
    
        YY& = DY% + ROWi% * HGHrow_lst
        Y1% = YY& - 30: Y2% = YY& + HGHfrm_lst
        STC_CTR.RecLstPct.Line (X1%, Y1%)-(X2%, Y2%), COLbkc_lst, BF
          If RECx% > StcCtr.NBRrec Then Exit For
    
        StcCtrShwRecord RECx%, YY&
      Next ROWi%

  Else
    STC_CTR.RecLstPct.BackColor = COLbkc_lst
    
      For ROWi% = 1 To StcCtr.NBRrow
        RECx% = ROWi% + StcCtr.NBRscr
          If RECx% > StcCtr.NBRrec Then Exit For
    
        YY& = DY% + ROWi% * HGHrow_lst
        StcCtrShwRecord RECx%, YY&
      Next ROWi%
    
  End If
  

'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'**************************************** ANZEIGE EINES RECORDS *****************************************
'
  Sub StcCtrShwRecord(RECx%, YY&)
'
'........................................................................................................
      
STC_CTR.RecLstPct.CurrentY = YY&

P2% = InStr(StcCtr.RECdat(RECx%), Chr(1))
VALx$ = Mid(StcCtr.RECdat(RECx%), 1, P2% - 1)
STC_CTR.RecLstPct.CurrentX = StcCtr.TABlst(1) - STC_CTR.RecLstPct.TextWidth(VALx$)
STC_CTR.RecLstPct.Print VALx$;
    
P1% = P2% + 1: P2% = InStr(P1%, StcCtr.RECdat(RECx%), Chr(2))
VALx$ = Mid(StcCtr.RECdat(RECx%), P1%, P2% - P1%)
STC_CTR.RecLstPct.CurrentX = StcCtr.TABlst(1) + 180
STC_CTR.RecLstPct.Print VALx$;

  For CLMi% = 3 To 10
    P1% = P2% + 1: P2% = InStr(P1%, StcCtr.RECdat(RECx%), Chr(CLMi%))

    VALx$ = Mid(StcCtr.RECdat(RECx%), P1%, P2% - P1%)
    If Not CLMi% = 10 Then VALx$ = VALx$ + "" Else VALx$ = VALx$ + " m"
    STC_CTR.RecLstPct.CurrentY = YY&
    STC_CTR.RecLstPct.CurrentX = StcCtr.TABlst(CLMi%) - STC_CTR.RecLstPct.TextWidth(VALx$)
    STC_CTR.RecLstPct.Print VALx$;
  Next CLMi%

'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'***************************** BERECHNUNG DES FLUGFELDES EINES WETTBEWERBS ******************************
'
   Sub StcCtrClcLocation()
'
'  StcCtr.NBRrec- Anzahl der Mestellen des Wettbewerbs
'  RCTstc_hrz() - Werte rechter HorizontalWinkel
'  RCTstc_vtc() - Werte rechter VertikalWinkel
'  ALPstc_lnc() - Gemessene Winkel der Mestellen zur vorherigen Mestelle
'  ALPstl_bgm() - Werte ALPstc_lnc() umgerechnet in Bogenma
'  BTAstc_lnc() - Gemessene Winkel der Mestellen zur nchsten Mestelle
'  BTAstl_bgm() - Werte BTAstc_lnc() umgerechnet in Bogenma
'  GMAstc_lnc() - Gemessene VertikalWinkel der Mestellen zur StartStelle
'  GMAstc_bgm() - Werte GMAstc_lnc() umgerechnet in Bogenma
'  DSTstc_lnc() - Gemessene Abstnde der Mestellen zur StartStelle
'
'          Z                DSTstc_lnc(1)
'        <-------     M1--------------------- L
'                      \ BTAstc_lnc(1)      .   .
'                       \             OMG .       .
'                        \              .           .
'                         \           .   DSTstc_lnc_pxz       usw.
'            DSTstc_stc(1) \  ALPstc_lnc(2)             ./
'                           \     .                     / .
'                            \  .  BTAstc_lnc(2)       /    .
'                             M2-------------------- M3       .
'                                  DSTstc_stc(2)                . X
'
'
'  OMGstl_bgm() - Winkel zwischen AbstandsLinie zur StartStelle und Z-Achse
'  DSTstc_lnc_pxz() - Projektion von DSTstc_lnc() auf die Ebene der StartStelle
'
'  ERRomg_grd   - WinkelDifferenz zum VollKreis
'
'........................................................................................................


'............................................................................ LISTE DER MESSSTELLEN-PAARE

'............................................................................. Anzahl der MestellenPaare
NBRstc_duo = 0

  For STCi% = 1 To StcCtr.NBRrec - 1
    NBRstc_duo = NBRstc_duo + STCi%
  Next STCi%


'........................................................................ UMRECHNUNG DER POSITIONS-WINKEL

  For STCi% = 1 To StcCtr.NBRrec
    ALPstl_bgm(STCi%) = Pi090 * ALPstc_lnc(STCi%) / RCTstc_hrz(STCi%)
    BTAstl_bgm(STCi%) = Pi090 * BTAstc_lnc(STCi%) / RCTstc_hrz(STCi%)
    GMAstl_bgm(STCi%) = Pi090 * GMAstc_lnc(STCi%) / RCTstc_vtc(STCi%)
  Next STCi%


'............................................. RAUMKOORDINATEN UND WINKEL DER ABSTANDS-LINIEN ZUR Z-ACHSE
'
'                                              DSTstc_lnc_pxz
'                              -------------------------------------------0
'                                    .       GMA                          |
'                                            .                            |
'                                                    .                    | YYY
'                                                           .             |
'                                                                   .     |
'                                                                         |
'
'........................................................................................................
'
'                                                         ZZZn            |
'                              -------------------------------------------|--------
'                                                           :           ..|
'                                                           : OMGn-1 .  . |
'                                                           :     .    .  |
'                                                           :  .      .   |
'                                                           :        .    |
'                                                        .  :       .     |
'                                                 Mn-1.     :      . OMGn |
'                                                    \BTAn-1:     .       |
'                                                     \     :    .        |
'                                                      \    :   . DSTn    |
'                                                       \   :  .          |
'                                                        \ALPn.           |
'                                                         \ :.            |
'                                                          \..............| XXXn
'                                                          . Mn           |
'                                                        N.
'........................................................................................................


'............................................................................................ Mestelle 1
DSTstc_lnc_pxz(1) = DSTstc_lnc(1) * Cos(-GMAstl_bgm(1))
ZZZstc_loc(1) = DSTstc_lnc_pxz(1)
OMGstl_bgm(1) = 0

  '.................................................................................... brige Mestellen
  For STCi% = 2 To StcCtr.NBRrec
    DSTstc_lnc_pxz(STCi%) = DSTstc_lnc(STCi%) * Cos(-GMAstl_bgm(STCi%))
    OMGstl_bgm(STCi%) = OMGstl_bgm(STCi% - 1) + Pi180 - ALPstl_bgm(STCi%) + BTAstl_bgm(STCi% - 1)
    
    XXXstc_loc(STCi%) = DSTstc_lnc_pxz(STCi%) * Sin(OMGstl_bgm(STCi%))
    ZZZstc_loc(STCi%) = DSTstc_lnc_pxz(STCi%) * Cos(OMGstl_bgm(STCi%))
    YYYstc_loc(STCi%) = DSTstc_lnc_pxz(STCi%) * Sin(-GMAstl_bgm(STCi%))
  Next STCi%

'............................................................................... DIFFERENZ ZUM VOLL-KREIS
'
'                                                        Mn ..............| XXXn
'                                                         . :.            |
'                                                       .   : .           |
'ERRomg = 360 - (OMGn + (180 - ABS(ALP1) - ABS(BTAn))).     :  .          |
'                                                   .       :   .         |
'                                                 .    BTAn :    .        |
'                                               .           :     .  OMGn |
'                                             .             :      .      |
'                                           .               :       .     |
'                                         .                 :        .    |
'                                       .                   :         .   |
'                                     .                     :          .  |
'                                   .   ALP1                :           . |
'                                 .                         :            .|
'                              -------------------------------------------|--------
'                                M1                        ZZZn           |
'........................................................................................................

ERRomg_bgm# = Pi180 - OMGstl_bgm(StcCtr.NBRrec) + Abs(ALPstl_bgm(1)) + Abs(BTAstl_bgm(StcCtr.NBRrec))
ERRomg_bgm# = 0

ERRomg_grd = ERRomg_bgm# * (90 / Pi090)
If ERRomg_grd < -180 Then ERRomg_grd = ERRomg_grd + 360
If ERRomg_grd > 180 Then ERRomg_grd = ERRomg_grd - 360

'.......................................................... ABSTNDE ZWISCHEN BENACHBARTEN MESS-STATIONEN
LSTdst_err = "" '.......................................... Liste der Stationen mit zu geringen Abstnden

'......................................................................................... Linke Nachbarn

'............................................................................................ Mestelle 1
DX# = XXXstc_loc(1) - XXXstc_loc(StcCtr.NBRrec)
DZ# = ZZZstc_loc(1) - ZZZstc_loc(StcCtr.NBRrec)
DY# = YYYstc_loc(1) - YYYstc_loc(StcCtr.NBRrec)
DSTstc_stc(1, 1) = Sqr(DX# ^ 2 + DZ# ^ 2 + DY# ^ 2)
If DSTstc_stc(1, 1) < 10 Then LSTdst_err = " 1&" + LTrim(Str(StcCtr.NBRrec)) + ","

  '.................................................................................... brige Mestellen
  For STCi% = 2 To StcCtr.NBRrec
    DX# = XXXstc_loc(STCi%) - XXXstc_loc(STCi% - 1)
    DZ# = ZZZstc_loc(STCi%) - ZZZstc_loc(STCi% - 1)
    DY# = YYYstc_loc(STCi%) - YYYstc_loc(STCi% - 1)
    DSTstc_stc(STCi%, 1) = Sqr(DX# ^ 2 + DZ# ^ 2 + DY# ^ 2)
    If DSTstc_stc(STCi%, 1) < 10 Then LSTdst_err = LSTdst_err + Str(STCi% - 1) + "&" + LTrim(Str(STCi%)) + ","
  Next STCi%

'........................................................................................ Rechte Nachbarn
  
  For STCi% = 1 To StcCtr.NBRrec - 1
    DX# = XXXstc_loc(STCi%) - XXXstc_loc(STCi% + 1)
    DZ# = ZZZstc_loc(STCi%) - ZZZstc_loc(STCi% + 1)
    DY# = YYYstc_loc(STCi%) - YYYstc_loc(STCi% + 1)
    DSTstc_stc(STCi%, 2) = Sqr(DX# ^ 2 + DZ# ^ 2 + DY# ^ 2)
  Next STCi%
  
'....................................................................................... Letzte Mestelle
DX# = XXXstc_loc(StcCtr.NBRrec) - XXXstc_loc(1)
DZ# = ZZZstc_loc(StcCtr.NBRrec) - ZZZstc_loc(1)
DY# = YYYstc_loc(StcCtr.NBRrec) - YYYstc_loc(1)
DSTstc_stc(StcCtr.NBRrec, 2) = Sqr(DX# ^ 2 + DZ# ^ 2 + DY# ^ 2)


'........................................................................................ PEILUNGS-FEHLER
'    - Differenz zwischen der berechneten Position einer Station
'      zum SchnittPunkt der PeilungsLinien der Nachbarstationen
'
'      Mehr als 2 MeStationen
'      ~~~~~~~~~~~~~~~~~~~~~~~
'
'         +Z        \                             |                                                  .
'      --------------\----------------------------|------------------------------------------------.-----
'               PHI1  \                         . |.                                    PHI2     .
'                      \              OMGn-1 .    | .                                          .
'                       \                 .       |  .                                       .
'                        \             .          |   .                                    .
'                         \         .             |    .                                 .
'                          \     .                |     .                              .
'                       Mn-1\ .                   |OMGn+1.                           .
'                            \  BTAn-1            |       .                        .
'                             \                   |        .                     .
'                              \                  |         .                  .
'                               \                 |          .               .
'                                \                |           .            .
'                                 \               |            .         .
'                                  \              |             .      .
'                                   \             |      ALPn+1  .   .
'                                    \            |                Mn+1
'                                     \           |              .
'                                      \  x       |            .
'                                       \  Mn     |          .
'                                        \        |        .     PHI - Winkel der PeilungsLinien
'                                         \       |      .             zur Z-Achse, AnstiegsWinkel
'                                          \      |    .               der Funktion X = X0 + Z*tan(PHI)
'                                           \     |  .
'                                            \    |.
'                                             \  .| X02           X0 - SchnittStellen der
'                                              .  |                    PeilungsLinien mit der X-Achse,
'                                            .  \ |                    NullPunkt der Funktion
'                                                \| X01                X = X0 + Z*tan(PHI)
'........................................................................................................
'
'      2 MeStationen: Schnittpunkte zwischen PeilungsLinien und AbstandsLinien zur StartStelle
'      ~~~~~~~~~~~~~~                                                                              |
'         +Z        .            M1                                                                | LNC
'      --------------.----------x------------------------------------------------------------------0-----
'                  Zc1.       Z1 .  BTA1       : Z2    : Zc2                                     . |
'                      .          .            :       :                                       .   |
'                       .          .           :       :                                     .     |
'                        .          .          :       :                                   .       |
'                         .          .         :       :                                 .         |
'                          .          .        :       :                               .           |
'                           .          .       :       :                      OMG2   .             |
'                            .          .      :       :                           .               |
'                             .          .     :       :                         .                 |
'                              .          .    :       :                       .                   |
'                               .          .   :       :                     .                     |
'                                .          .  :       :                   .                       |
'                                 .          . :       :                 .                         |
'                                  .          .:       :               .                           |
'                                   .          :       :             .                             |
'                                    .         :.      :           .   DSTx                        |
'                                     .        : .     :         .                                 |
'                                      .       :  .  PHI1      .                                   | +X
'                                       .      :   .   :     .
'                                        . PHI2:    .  :   .
'                                         .    :     . : .
'                                          .   :      ..                       PHI2 = OMG2 + ALP2 - 90
'                                           .  ALP2  . . Zc2,Xc2               Zc1 = Z2 + tan(PHI2)  X2
'                                            . :   .    .
'                                             .: .       .                 PHI1 = 180 - OMG2 - BTA1
'                                              x                           DSTx = Z1  sin(BTA1)/sin(PHI1)
'                                           M2                              Xc2 = DSTx  sin(OMG2)
'                                                                           Zc2 = DSTx  cos(OMG2)
'........................................................................................................



LSTstc_err = "" '............................................... Liste der Stationen mit kritischen Daten


  If StcCtr.NBRrec > 2 Then
    '....................................................................................... MeStation 1
        
    '............................................................................... Linke NachbarStation
    PHI1# = OMGstl_bgm(StcCtr.NBRrec) + BTAstl_bgm(StcCtr.NBRrec)
    X10# = XXXstc_loc(StcCtr.NBRrec) - ZZZstc_loc(StcCtr.NBRrec) * Tan(PHI1#)
        
    '.............................................................................. Rechte NachbarStation
    PHI2# = OMGstl_bgm(2) + ALPstl_bgm(2)
    X20# = XXXstc_loc(2) - ZZZstc_loc(2) * Tan(PHI2#)
        
    DTNx# = Tan(PHI1#) - Tan(PHI2#)
          
      If Abs(DTNx#) > 0.01 Then
        '.............................................. Koordinaten des SchnittPunktes der PeilungsLinien
        ZZZvsl_crs(1) = (X20# - X10#) / DTNx#
        XXXvsl_crs(1) = X10# + ZZZvsl_crs(1) * Tan(PHI1#)
    
        '................................................... Mittlerer Abstand zu beiden NachbarStationen
        DSTx# = 0.5 * (DSTstc_stc(1, 1) + DSTstc_stc(1, 2))
        
        '......... Prfung der berechneten Position der Station und des SchnittPunktes der PeilungsLinien
        DX# = XXXstc_loc(1) - XXXvsl_crs(1): DZ# = ZZZstc_loc(1) - ZZZvsl_crs(1)
        If Abs(Sqr(DX# ^ 2 + DZ# ^ 2) / DSTx#) > 0.1 Then LSTstc_err = " 1,"
      Else
        ZZZvsl_crs(1) = ZZZstc_loc(1)
        XXXvsl_crs(1) = XXXstc_loc(1)
      End If
    
    YYYvsl_crs(1) = YYYstc_loc(1)
      
      For STCi% = 2 To StcCtr.NBRrec - 1
        PHI1# = OMGstl_bgm(STCi% - 1) + BTAstl_bgm(STCi% - 1)
        X10# = XXXstc_loc(STCi% - 1) - ZZZstc_loc(STCi% - 1) * Tan(PHI1#)
            
        PHI2# = OMGstl_bgm(STCi% + 1) + ALPstl_bgm(STCi% + 1)
        X20# = XXXstc_loc(STCi% + 1) - ZZZstc_loc(STCi% + 1) * Tan(PHI2#)
            
        DTNx# = Tan(PHI1#) - Tan(PHI2#)
              
          If Abs(DTNx#) > 0.01 Then
            ZZZvsl_crs(STCi%) = (X20# - X10#) / DTNx#
            XXXvsl_crs(STCi%) = X10# + ZZZvsl_crs(STCi%) * Tan(PHI1#)
        
            DSTx# = 0.5 * (DSTstc_stc(STCi%, 1) + DSTstc_stc(STCi%, 2))
            DX# = XXXstc_loc(STCi%) - XXXvsl_crs(STCi%): DZ# = ZZZstc_loc(STCi%) - ZZZvsl_crs(STCi%)
            If Abs(Sqr(DX# ^ 2 + DZ# ^ 2) / DSTx#) > 0.1 Then LSTstc_err = LSTstc_err + Str(STCi%) + ","
          Else
            ZZZvsl_crs(STCi%) = 0.5 * (ZZZstc_loc(STCi% - 1) + ZZZstc_loc(STCi% + 1))
            XXXvsl_crs(STCi%) = 0.5 * (XXXstc_loc(STCi% - 1) + XXXstc_loc(STCi% + 1))
          End If
        
        YYYvsl_crs(STCi%) = YYYstc_loc(STCi%)
        
      Next STCi%
      
      
    '.................................................................................. Letzte MeStation
    PHI1# = OMGstl_bgm(StcCtr.NBRrec - 1) + BTAstl_bgm(StcCtr.NBRrec - 1)
    X10# = XXXstc_loc(StcCtr.NBRrec - 1) - ZZZstc_loc(StcCtr.NBRrec - 1) * Tan(PHI1#)
        
    PHI2# = OMGstl_bgm(1) + ALPstl_bgm(1)
    X20# = XXXstc_loc(1) - ZZZstc_loc(1) * Tan(PHI2#)
        
    DTNx# = Tan(PHI1#) - Tan(PHI2#)
          
      If Abs(DTNx#) > 0.01 Then
        ZZZvsl_crs(StcCtr.NBRrec) = (X20# - X10#) / DTNx#
        XXXvsl_crs(StcCtr.NBRrec) = X10# + ZZZvsl_crs(StcCtr.NBRrec) * Tan(PHI1#)
    
        DSTx# = 0.5 * (DSTstc_stc(StcCtr.NBRrec, 1) + DSTstc_stc(StcCtr.NBRrec, 2))
        DX# = XXXstc_loc(StcCtr.NBRrec) - XXXvsl_crs(StcCtr.NBRrec)
        DZ# = ZZZstc_loc(StcCtr.NBRrec) - ZZZvsl_crs(StcCtr.NBRrec)
        If Abs(Sqr(DX# ^ 2 + DZ# ^ 2) / DSTx#) > 0.1 Then LSTstc_err = LSTstc_err + Str(StcCtr.NBRrec) + ","
      Else
        ZZZvsl_crs(StcCtr.NBRrec) = ZZZstc_loc(StcCtr.NBRrec)
        XXXvsl_crs(StcCtr.NBRrec) = XXXstc_loc(StcCtr.NBRrec)
      End If
    
    YYYvsl_crs(StcCtr.NBRrec) = YYYstc_loc(StcCtr.NBRrec)
  
  
  Else
    
    '.................................... SchnittPunkt der PeilungsLinie der MeStation 2 und der Z-Achse
    'PHI2# = OMGstl_bgm(2) + Abs(ALPstl_bgm(2)) - Pi090    ' Nix ABS !!
    PHI2# = OMGstl_bgm(2) + ALPstl_bgm(2) - Pi090
    ZZZvsl_crs(1) = ZZZstc_loc(2) + XXXstc_loc(2) * Tan(PHI2#)
    XXXvsl_crs(1) = 0
    YYYvsl_crs(1) = YYYstc_loc(1)
    
    DZ# = ZZZstc_loc(1) - ZZZvsl_crs(1)
    If Abs(DZ# / DSTstc_stc(1, 2)) > 0.1 Then LSTstc_err = " 1,"
    
    
    '............. SchnittPunkt der PeilungsLinie der MeStation 1 und der AbstandsLinie der MeStation 2
    'PHI1# = Pi180 - OMGstl_bgm(2) - Abs(BTAstl_bgm(1))   ' Nix ABS !!
    PHI1# = Pi180 - OMGstl_bgm(2) - BTAstl_bgm(1)
      
      If Sin(PHI1#) <> 0 Then
        DSTx# = Abs(ZZZstc_loc(1) * Sin(BTAstl_bgm(1)) / Sin(PHI1#))
      Else
        DSTx# = DSTstc_lnc(2)
      End If
      
    ZZZvsl_crs(2) = DSTx# * Cos(OMGstl_bgm(2))
    XXXvsl_crs(2) = DSTx# * Sin(OMGstl_bgm(2))
    YYYvsl_crs(2) = YYYstc_loc(2)
    
    DX# = XXXstc_loc(2) - XXXvsl_crs(2): DZ# = ZZZstc_loc(2) - ZZZvsl_crs(2)
    If Abs(Sqr(DX# ^ 2 + DZ# ^ 2) / DSTstc_stc(1, 2)) > 0.1 Then LSTstc_err = LSTstc_err + " 2,"

  End If
  
'********************************************************************************************************
                                                                                                  End Sub


