Attribute VB_Name = "SAC_FNC"
'########################################################################################################
'######################################### Altitude-Calculator ##########################################
'########################################################################################################


#If Win16 Then
    Declare Sub SetCursorPos Lib "User" (ByVal x As Integer, ByVal y As Integer)
    Declare Sub GetCursorPos Lib "User" (lpPoint As POINTAPI)
    
    Type POINTAPI
      x As Integer
      y As Integer
    End Type
#Else
    Declare Function GetCursorPos Lib "user32" (lpPoint As POINTAPI) As Long
    Declare Function SetCursorPos Lib "user32" (ByVal x As Long, ByVal y As Long) As Long

    Type POINTAPI
      x As Long
      y As Long
    End Type

#End If

Global APIpos As POINTAPI

Global OBJfnc_s1x As Object '......................................... FormularObjekt globaler Prozeduren

'............................................................................. StandardWinkel in Bogenma
Global Pi090 As Double: Global Pi180 As Double
Global Pi270 As Double: Global Pi360 As Double

Global LFTfrm_ctr As Integer, TOPfrm_ctr As Integer '........................ Position des HauptFormulars
Global LFTfrm_stc As Integer, TOPfrm_stc As Integer '..................... Position des StationsFormulars
Global LFTfrm_loc As Integer, TOPfrm_loc As Integer '.................................. Position Location
Global LFTfrm_msr As Integer, TOPfrm_msr As Integer '................................... Position Measure

Global DTMsys_nbr As String '..................................................... SystemDatum DD.MM.YYYY
Global PTHatt_hom As String '................................................................... HomePfad
Global FLNatt_dat As String '.................................................. Aktuelle WettbewerbsDatei
Global TXTmsg_stp As String '................................................................ StopMassage


Global RCTstc_hrz(3) As Integer '......................................... Werte rechter HorizontalWinkel
Global RCTstc_vtc(3) As Integer '........................................... Werte rechter VertikalWinkel

Global ALPstc_lnc(3) As Single '.................... Winkel zwischen StartStelle und vorheriger Mestelle
Global BTAstc_lnc(3) As Single '...................... Winkel zwischen StartStelle und nchster Mestelle
Global GMAstc_lnc(3) As Single '....................... VertikalWinkel zwischen Mestelle und StartStelle
Global DSTstc_lnc(3) As Double '................... Gemessene Abstnde der Mestellen zur StartStelle [m]

Global ALPstl_bgm(3) As Double '.............................. Werte ALPstc_lnc() umgerechnet in Bogenma
Global BTAstl_bgm(3) As Double '.............................. Werte BTAstc_lnc() umgerechnet in Bogenma
Global GMAstl_bgm(3) As Double '.............................. Werte GMAstc_lnc() umgerechnet in Bogenma

Global DSTstl_pxz(3) As Integer '.............. Projektion von DSTstc_lnc() auf die Ebene der StartStelle
Global OMGstl_bgm(3) As Double '............... Winkel zwischen AbstandsLinie zur StartStelle und Z-Achse
Global ERRomg_grd As Integer '............................................. WinkelDifferenz zum VollKreis

Global XXXstc_loc(3) As Double '........................................ X-RaumKoordinaten der Mestellen
Global ZZZstc_loc(3) As Double '........................................ Z-RaumKoordinaten der Mestellen
Global YYYstc_loc(3) As Double '........................................ Y-RaumKoordinaten der Mestellen


Global ALPmsr_apg(3) As Double '.......................................... HorizontalWinkel der Peilungen
Global ALPapg_bgm(3) As Double '...................... PeilungWinkel ALPmsr_apg() umgerechnet in Bogenma

Global GMAmsr_apg(3) As Double '............................................ VertikalWinkel der Peilungen
Global GMAapg_bgm(3) As Double '...................... PeilungWinkel GMAmsr_apg() umgerechnet in Bogenma

Global YYYduo_apg(3) As Double '...................................... Y-RaumKoordinate des VisierPunktes
Global XXXduo_apg(3) As Double '...................................... X-RaumKoordinate des VisierPunktes
Global ZZZduo_apg(3) As Double '...................................... Z-RaumKoordinate des VisierPunktes

Global XXXstc_apg(3, 3) As Double '......... X-RaumKoordinate der DriftLinie einer Station eines Prchens
Global ZZZstc_apg(3, 3) As Double '......... Z-RaumKoordinate der DriftLinie einer Station eines Prchens

Global YYYfly_apg As Double '.......................................................... DurchschnittsHhe
Global XXXfly_apg As Double '........................................................... X-RaumKoordinate
Global ZZZfly_apg As Double '........................................................... Z-RaumKoordinate


Global ERRduo_hrz(3) As Integer '.................... Fehler der horizontalen Messungen der StationsPaare
Global ERRduo_vtc(3) As Integer '...................... Fehler der vertikalen Messungen der StationsPaare

Global CLCduo_apg(3) As Integer '..................................... GltigkeitsFlag des StationsPaares

Global DSTfly_hrz As Integer '.................... Durchschnittlicher geringster Abstand der VisierLinien
Global ERRfly_hrz As Integer '................................. Durchschnittlicher Fehler Drift/Hhe in %

Global DSTfly_vtc As Integer '.................................... Durchschnittliche HhenAbweichung in m
Global ERRfly_vtc As Integer '....................... Durchschnittlicher HhenFehler Abweichung/Hhe in %

Global CLCfly_apg As Integer '................................................ GltigkeitsFlag des Fluges


'********************************************************************************************************
'**************************************** BERECHNUNG DER FLUGHHE ***************************************
'
   Sub SacClcMsrValues()
'
'                 Berechnung nach FAI:
'                 H1# = DSTmsr_msr(0) * Tan(AV2#) * Tan(GV1#) / (Sin(AV1#) * (1 + Tan(AV2#) / Tan(AV1#)))
'                 H2# = DSTmsr_msr(0) * Tan(AV1#) * Tan(GV2#) / (Sin(AV2#) * (1 + Tan(AV1#) / Tan(AV2#)))
'
'........................................................................................................
   
   
'......................................................................... UMRECHNUNG DER PEILUNGS-WINKEL

  For STCi% = 1 To 3
    ALPapg_bgm(STCi%) = Pi090 * ALPmsr_apg(STCi%) / RCTstc_hrz(STCi%)
    GMAapg_bgm(STCi%) = Pi090 * GMAmsr_apg(STCi%) / RCTstc_vtc(STCi%)
      
      If GMAapg_bgm(STCi%) > Pi090 Then
        GMAapg_bgm(STCi%) = Pi090 - (GMAapg_bgm(STCi%) - Pi090)
        ALPapg_bgm(STCi%) = ALPapg_bgm(STCi%) - Pi180
        If ALPapg_bgm(STCi%) < 0 Then ALPapg_bgm(STCi%) = ALPapg_bgm(STCi%) + Pi360
      End If
    
  Next STCi%

   

'........................................................................... WERTE DER MESS-STELLEN-PAARE
NBRduo_apg% = 0 '............................................. Anzahl MestellenPaare mit gltigen Werten
  
DUOx% = 1: STC1% = 1: STC2% = 2: YYYduo_apg(DUOx%) = 0: CLCduo_apg(DUOx%) = 0
If Not GMAapg_bgm(STC1%) * GMAapg_bgm(STC2%) = 0 Then GoSub ClcMsrDuo
  
DUOx% = 2: STC1% = 2: STC2% = 3: YYYduo_apg(DUOx%) = 0: CLCduo_apg(DUOx%) = 0
If Not GMAapg_bgm(STC1%) * GMAapg_bgm(STC2%) = 0 Then GoSub ClcMsrDuo
  
DUOx% = 3: STC1% = 3: STC2% = 1: YYYduo_apg(DUOx%) = 0: CLCduo_apg(DUOx%) = 0
If Not GMAapg_bgm(STC1%) * GMAapg_bgm(STC2%) = 0 Then GoSub ClcMsrDuo
  

    If NBRduo_apg% = 0 Then CLCfly_apg = 0: Exit Sub


'.............................................................................................. END-WERTE
XXX# = 0: YYY# = 0: ZZZ# = 0

  For DUOi% = 1 To 3
  
      If Not CLCduo_apg(DUOi%) = 0 Then
        XXX# = XXX# + XXXduo_apg(DUOi%)
        YYY# = YYY# + YYYduo_apg(DUOi%)
        ZZZ# = ZZZ# + ZZZduo_apg(DUOi%)
      End If
      
  Next DUOi%
  
'...................................................................................... VisierMittelpunkt
XXXfly_apg = Fix(XXX# / NBRduo_apg%)
YYYfly_apg = Fix(YYY# / NBRduo_apg%)
ZZZfly_apg = Fix(ZZZ# / NBRduo_apg%)

'.......................................................................................... GESAMT-FEHLER

'................................................................................. Horizontale Abweichung
DXZ# = 0

  For DUOi% = 1 To 3
      
      If Not CLCduo_apg(DUOi%) = 0 Then
        DX# = XXXfly_apg - XXXduo_apg(DUOi%)
        DZ# = ZZZfly_apg - ZZZduo_apg(DUOi%)
        DXZ# = DXZ# + Sqr(DX# ^ 2 + DZ# ^ 2)
      End If
      
  Next DUOi%

DSTfly_hrz = Fix(DXZ# / NBRduo_apg%)
ERRfly_hrz = Fix(100 * DSTfly_hrz / YYYfly_apg)
 
'............................................................................................. HhenWerte
DDY# = 0

  For DUOi% = 1 To 3
    If Not CLCduo_apg(DUOi%) = 0 Then DDY# = DDY# + Abs(YYYfly_apg - YYYduo_apg(DUOi%))
  Next DUOi%

DSTfly_vtc = Fix(DDY# / NBRduo_apg%)
ERRfly_vtc = Fix(100 * DSTfly_vtc / YYYfly_apg)
If ERRfly_vtc > 10 Then CLCfly_apg = 0 Else CLCfly_apg = 1


'................................................................................................ RUNDEN

  For DUOi% = 1 To 3
    YYYduo_apg(DUOi%) = Fix(YYYduo_apg(DUOi%))
  Next DUOi%

'.............................................................................................. PROTOKOLL
FLNprt$ = PTHatt_hom + "\" + FLNatt_dat

  If Dir(FLNprt$) = "" Then
    Open FLNprt$ For Output As #99

    Print #99, "Protokoll vom "; DTMsys_nbr
    
      For STCi% = 1 To 3
        Print #99, "MeStation"; STCi%

        Print #99, "Rechter Winkel der horizontalen Messung:"; Chr(9); RCTstc_hrz(STCi%); ""
        Print #99, "Rechter Winkel der vertikalen Messung:"; Chr(9); RCTstc_vtc(STCi%); ""

        Print #99, "HorizontalWinkel zur linken NachbarStation:"; Chr(9); ALPstc_lnc(STCi%); ""
        Print #99, "HorizontalWinkel zur rechten NachbarStation:"; Chr(9); BTAstc_lnc(STCi%); ""

        Print #99, "VertikalWinkel zur Startstelle:"; Chr(9); Str(GMAstc_lnc(STCi%)); ""
        Print #99, "Abstand zur Startstelle:"; Chr(9); Str(DSTstc_lnc(STCi%)); "m"
      Next STCi%
      
    Print #99, ""
    Print #99, "WinkelDifferenz zum Volllkreis:"; Chr(9); ERRomg_grd; ""
    
  Else
    Open FLNprt$ For Append As #99
  End If
  
  For STCi% = 1 To 3
    Print #99, Chr(9); Chr(9); LTrim(Str(ALPmsr_apg(STCi%))); ""; Chr(9); LTrim(Str(GMAmsr_apg(STCi%))); ""; Chr(9);
  Next STCi%
    
  For DUOi% = 1 To 3
  
      If Not YYYduo_apg(DUOi%) = 0 Then
        Print #99, LTrim(Str(YYYduo_apg(DUOi%))); "m"; Chr(9);
        Print #99, LTrim(Str(ERRduo_hrz(DUOi%))); ""; Chr(9);
        Print #99, LTrim(Str(ERRduo_vtc(DUOi%))); ""; Chr(9);
        If CLCduo_apg(DUOi%) = 0 Then Print #99, "DQ"; Else Print #99, "OK";
      Else
        Print #99, "-"; Chr(9); "-"; Chr(9); "-"; Chr(9); "-";
      End If
      
    Print #99, Chr(9);
  Next DUOi%

Print #99, LTrim(Str(YYYfly_apg)); "m"; Chr(9);
Print #99, LTrim(Str(DSTfly_vtc)); "m"; Chr(9); LTrim(Str(ERRfly_vtc)); "%"; Chr(9);
If CLCfly_apg = 0 Then Print #99, "DQ"; Else Print #99, "OK";
Print #99, Chr(9)
Close


                                                                                                 Exit Sub
'********************************************************************************************************
'--------------------------------------------------------------------------------------------------------
'----------------------------------- ERGEBNIS EINES STATIONS-PAARES -------------------------------------
ClcMsrDuo:
      
                                                              '                      --------/
                                                              '                        |    /:
TNGgma1# = Tan(GMAapg_bgm(STC1%))                             '                        |   / :
TNGgma2# = Tan(GMAapg_bgm(STC2%))                             '           DSTclc_apg   |  /  :
                                                              '                        | /   :
                                                              '                        |/    :
                                                              '                      --/     :
                                                              '                       /: GMA :
                                                              '                      / :     :
                                                              '                      ------------
                                                              '                           DXZ


ALPmsr1# = OMGstl_bgm(STC1%) + ALPapg_bgm(STC1%) + Pi180      '               Z              |
SNStng1# = Sin(ALPmsr1#) / TNGgma1#                           '      ---------:--------------.-
CSNtng1# = Cos(ALPmsr1#) / TNGgma1#                           '           .   :         OMG .|
                                                              '            .  :            . |
ALPmsr2# = OMGstl_bgm(STC2%) + ALPapg_bgm(STC2%) + Pi180      '             . :           .  |
SNStng2# = Sin(ALPmsr2#) / TNGgma2#                           '              .:          .   |
CSNtng2# = Cos(ALPmsr2#) / TNGgma2#                           '               ...............|X
                                                              '                .       .     |
                                                              '             DXZ .     .      |
                                                              '                  .ALPapg     |
                                                              '                   . .        |
                                                              '            ALPmsr  .         |
       
        
'............................................................... AusgangsHhe (Hhe der hchsten Station)
Y0# = YYYstc_loc(STC1%)
If YYYstc_loc(STC2%) > Y0# Then Y0# = YYYstc_loc(STC2%)

'..................................................... Koordinaten der PeilungsLinien in der AusgangsHhe
YY# = Y0#
Y1# = YY# - YYYstc_loc(STC1%)
X1# = XXXstc_loc(STC1%) + Y1# * SNStng1#: Z1# = ZZZstc_loc(STC1%) + Y1# * CSNtng1#

Y2# = YY# - YYYstc_loc(STC2%)
X2# = XXXstc_loc(STC2%) + Y2# * SNStng2#: Z2# = ZZZstc_loc(STC2%) + Y2# * CSNtng2#

'............................................ Horizontaler Abstand der PeilungsLinien in der AusgangsHhe
DSTmin# = (X1# - X2#) ^ 2 + (Z1# - Z2#) ^ 2
      
'......................... Ermittlung der Hhe mit dem geringsten horizontalen Abstand der PeilungsLinien
DSTclc_apg = 0.3 '..................................................... Raster der AbstandsBerechnung [m]

  Do
    Y1# = YY# + DSTclc_apg - YYYstc_loc(STC1%)
    X1# = XXXstc_loc(STC1%) + Y1# * SNStng1#: Z1# = ZZZstc_loc(STC1%) + Y1# * CSNtng1#
  
    Y2# = YY# + DSTclc_apg - YYYstc_loc(STC2%)
    X2# = XXXstc_loc(STC2%) + Y2# * SNStng2#: Z2# = ZZZstc_loc(STC2%) + Y2# * CSNtng2#
    
    DD# = (X1# - X2#) ^ 2 + (Z1# - Z2#) ^ 2
      If Not DD# < DSTmin# Then Exit Do
  
    DSTmin# = DD#
    YY# = YY# + DSTclc_apg
  Loop


XXXstc_apg(DUOx%, STC1%) = X1#: XXXstc_apg(DUOx%, STC2%) = X2#
ZZZstc_apg(DUOx%, STC1%) = Z1#: ZZZstc_apg(DUOx%, STC2%) = Z2#

'....................................................... Koordinaten des VisierPunktes des StationsPaares
YYYduo_apg(DUOx%) = YY#
XXXduo_apg(DUOx%) = 0.5 * (X1# + X2#)
ZZZduo_apg(DUOx%) = 0.5 * (Z1# + Z2#)


'............................................................ WinkelFehler der Messung des StationsPaares
SacClcDuoError DUOx%
If CLCduo_apg(DUOx%) = 1 Then NBRduo_apg% = NBRduo_apg% + 1
    
  
                                                                                                   Return
'--------------------------------------------------------------------------------------------------------
'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'********************************************************************************************************
'
  Sub SacFrmMove(OBJfnc_s1x, KEYx%, CTRx%)
'
'........................................................................................................


  Select Case CTRx%
    Case 4 '......................................................................................... ALT
      DPSx% = 60
    Case 5 '..................................................................................... SFT+ALT
      DPSx% = 240
    Case Else
      Exit Sub
  End Select
      

LFTfrm% = OBJfnc_s1x.Left: TOPfrm% = OBJfnc_s1x.Top
WDTfrm% = OBJfnc_s1x.Width: HGHfrm% = OBJfnc_s1x.Height
GetCursorPos APIpos

LFTnew% = LFTfrm%: TOPnew% = TOPfrm%
      
  Select Case KEYx%
    Case 18 '........................................................................................ Alt
      XX& = 15 * APIpos.x: YY& = 15 * APIpos.y
        
        If XX& < LFTfrm% Or XX& > LFTfrm% + WDTfrm% Or YY& < TOPfrm% Or YY& > TOPfrm% + HGHfrm% Then
          XX& = (LFTfrm% + 450) / 15: YY& = (TOPfrm% + 390) / 15
          SetCursorPos XX&, YY&
        End If
        
      Exit Sub
    
    Case 37 '....................................................................................... Left
      LFTnew% = LFTfrm% - DPSx%: If LFTnew% < 0 Then LFTnew% = 0
        
    Case 39 '...................................................................................... Right
      LFTnew% = LFTfrm% + DPSx%
      If LFTnew% + WDTfrm% > Screen.Width Then LFTnew% = Screen.Width - WDTfrm%

    Case 38 '......................................................................................... Up
      TOPnew% = TOPfrm% - DPSx%: If TOPnew% < 0 Then TOPnew% = 0
    
    Case 40 '......................................................................................... Dn
      TOPnew% = TOPfrm% + DPSx%
      If TOPnew% + HGHfrm% > Screen.Height Then TOPnew% = Screen.Height - HGHfrm%

    Case 115 '........................................................................................ F4
      Unload OBJtls_frm
      Exit Sub
      
    Case Else
      Exit Sub
  End Select
      
      
  If LFTnew% <> LFTfrm% Or TOPnew% <> TOPfrm% Then
    SetCursorPos APIpos.x + (LFTnew% - LFTfrm%) / 15, APIpos.y + (TOPnew% - TOPfrm%) / 15
    OBJfnc_s1x.Move LFTnew%, TOPnew%
  End If

KEYx% = 0

'********************************************************************************************************
                                                                                                  End Sub



'********************************************************************************************************
'************************************ EINBLENDEN EINES FORMULARS ****************************************
'
  Sub SacFrmZoom(OBJfnc_s1x, LFTfrm%, TOPfrm%, WDTfrm%, HGHfrm%, NN%, SETx%)
'
'........................................................................................................


OBJfnc_s1x.AutoRedraw = 0
  
  If SETx% = 0 Then '......................................................................... AUSBLENDEN
    If OBJfnc_s1x.Enabled = 1 Then OBJfnc_s1x.SetFocus
    OBJfnc_s1x.BackColor = OBJfnc_s1x.BackColor
    DoEvents
    
    If NN% = 0 Then NN% = 44
    
      If S1Xwrk_end = 0 Then '.............................................. Ausblenden auf FormularMitte
      
          If WDTfrm% > HGHfrm% Then
            DS% = WDTfrm% / NN%: DP% = 0.5 * DS%
          
              Do While HGHfrm% > DS%
                LFTfrm% = LFTfrm% + DP%: TOPfrm% = TOPfrm% + DP%
                WDTfrm% = WDTfrm% - DS%: HGHfrm% = HGHfrm% - DS%
                OBJfnc_s1x.Move LFTfrm%, TOPfrm%, WDTfrm%, HGHfrm%
                
                OBJfnc_s1x.Line (0, 0)-(WDTfrm% - 15, HGHfrm% - 15), &H808080, B
                DoEvents
              Loop
          
          Else
            DS% = HGHfrm% / NN%: DP% = 0.5 * DS%
          
              Do While WDTfrm% > DS%
                LFTfrm% = LFTfrm% + DP%: TOPfrm% = TOPfrm% + DP%
                WDTfrm% = WDTfrm% - DS%: HGHfrm% = HGHfrm% - DS%
                OBJfnc_s1x.Move LFTfrm%, TOPfrm%, WDTfrm%, HGHfrm%
                OBJfnc_s1x.Line (0, 0)-(WDTfrm% - 15, HGHfrm% - 15), &H808080, B
                DoEvents
              Loop
           
          End If
    
      Else '................................................ Ausblenden auf ExitSymbol des HauptFormulars
        NN% = 44
        XX& = S1X_CTR.Left + S1X_CTR.CtrPct.Left
        XX& = XX& + S1X_CTR.CtrImg(99).Left + 0.5 * S1X_CTR.CtrImg(99).Width
        YY& = S1X_CTR.Top + S1X_CTR.CtrPct.Top + 0.5 * S1X_CTR.CtrPct.Height
    
        LFTfrm% = OBJfnc_s1x.Left: TOPfrm% = OBJfnc_s1x.Top
        WDTfrm% = OBJfnc_s1x.Width: HGHfrm% = OBJfnc_s1x.Height
        

        DW! = WDTfrm% / NN%: DH! = HGHfrm% / NN%
        DX! = (XX& - LFTfrm% - 0.5 * WDTfrm%) / NN% + DW! / 2
        DY! = (YY& - TOPfrm% - 0.5 * HGHfrm%) / NN% + DH! / 2

       
          For N% = 1 To NN%
            LFTfrm% = LFTfrm% + DX!: TOPfrm% = TOPfrm% + DY!
            WDTfrm% = WDTfrm% - DW!: If WDTfrm% < 0 Then WDTfrm% = 0
            HGHfrm% = HGHfrm% - DH!: If HGHfrm% < 0 Then HGHfrm% = 0
            OBJfnc_s1x.Move LFTfrm%, TOPfrm%, WDTfrm%, HGHfrm%
            OBJfnc_s1x.Line (0, 0)-(WDTfrm% - 15, HGHfrm% - 15), &H808080, B
            DoEvents
          Next N%

      End If
      
    OBJfnc_s1x.Hide: DoEvents

  Else '...................................................................................... EINBLENDEN
    GetCursorPos APIpos: XX& = 15 * APIpos.x: YY& = 15 * APIpos.y '..................... QuellKoordinaten
    LFTtmp% = XX&: TOPtmp% = YY&: WDTtmp% = 0: HGHtmp% = 0 '......................... FormularKoordinaten
    
    OBJfnc_s1x.Move LFTtmp%, TOPtmp%, WDTtmp%, HGHtmp%: OBJfnc_s1x.Show: DoEvents
    OBJfnc_s1x.AutoRedraw = 0
    
    If NN% = 0 Then NN% = 33
    DW! = WDTfrm% / NN%: DH! = HGHfrm% / NN%
    DX! = (XX& - LFTfrm% - 0.5 * WDTfrm%) / NN% + DW! / 2
    DY! = (YY& - TOPfrm% - 0.5 * HGHfrm%) / NN% + DH! / 2
    C0& = OBJfnc_s1x.BackColor: C1& = &HFFFFFF: C2& = &H808080
    
    
      For N% = 1 To NN%
        OBJfnc_s1x.Line (0, 0)-(WDTtmp% - 15, HGHtmp% - 15), C0&, B
    
        LFTtmp% = LFTtmp% - DX!: TOPtmp% = TOPtmp% - DY!
        WDTtmp% = WDTtmp% + DW!: If WDTtmp% > WDTfrm% Then WDTtmp% = WDTfrm%
        HGHtmp% = HGHtmp% + DH!: If HGHtmp% > HGHfrm% Then HGHtmp% = HGHfrm%
        OBJfnc_s1x.Move LFTtmp%, TOPtmp%, WDTtmp%, HGHtmp%
    
        OBJfnc_s1x.Line (0, 0)-(WDTtmp% - 15, HGHtmp% - 15), 0, B
        DoEvents
      Next N%
    
    OBJfnc_s1x.Move LFTfrm%, TOPfrm%, WDTfrm%, HGHfrm%
    
    '............................................................................................. Border
    OBJfnc_s1x.AutoRedraw = 1

    OBJfnc_s1x.DrawWidth = 2
    C1& = &HFFFFFF: C2& = &H808080
    OBJfnc_s1x.Line (0, 0)-(WDTfrm% - 15, HGHfrm% - 15), C1&, B
    OBJfnc_s1x.Line (45, HGHfrm% - 15)-(WDTfrm% - 15, HGHfrm% - 15), C2&
    OBJfnc_s1x.Line (WDTfrm% - 15, 30)-(WDTfrm% - 15, HGHfrm% - 15), C2&
    
    OBJfnc_s1x.DrawWidth = 1
    OBJfnc_s1x.Line (0, 0)-(WDTfrm% - 15, HGHfrm% - 15), 0, B
    OBJfnc_s1x.PSet (15, HGHfrm% - 15), C2&
    OBJfnc_s1x.PSet (WDTfrm% - 15, 15), C2&

  End If
  
'********************************************************************************************************
                                                                                                  End Sub



'********************************************************************************************************
'***************************** BERECHNUNG DES FLUGFELDES EINES WETTBEWERBS ******************************
'
   Sub SacClcMsrLocation()
'
'  ATTnbr_stc   - Anzahl der Mestellen des Wettbewerbs
'  RCTstc_hrz() - Werte rechter HorizontalWinkel
'  RCTstc_vtc() - Werte rechter VertikalWinkel
'  ALPstc_lnc() - Gemessene Winkel der Mestellen zur vorherigen Mestelle
'  ALPstl_bgm() - Werte ALPstc_lnc() umgerechnet in Bogenma
'  BTAstc_lnc() - Gemessene Winkel der Mestellen zur nchsten Mestelle
'  BTAstl_bgm() - Werte BTAstc_lnc() umgerechnet in Bogenma
'  GMAstc_lnc() - Gemessene VertikalWinkel der Mestellen zur StartStelle
'  GMAstc_bgm() - Werte GMAstc_lnc() umgerechnet in Bogenma
'  DSTstc_lnc() - Gemessene Abstnde der Mestellen zur StartStelle
'
'          Z                DSTstc_lnc(1)
'        <-------     M1--------------------- L
'                      \ BTAstc_lnc(1)      .   .
'                       \             OMG .       .
'                        \              .           .
'                         \           .   DSTstl_pxz  .    usw.
'            DSTstc_duo(1) \  ALPstc_lnc(2)             ./
'                           \     .                     / .
'                            \  .  BTAstc_lnc(2)       /    .
'                             M2-------------------- M3       .
'                                  DSTstc_duo(2)                . X
'
'
'  OMGstl_bgm() - Winkel zwischen AbstandsLinie zur StartStelle und Z-Achse
'  DSTstl_pxz() - Projektion von DSTstc_lnc() auf die Ebene der StartStelle
'  XYZstc_loc() - RaumKoordinaten der Mestellen
'
'  ERRmsr_duo() - Fehler in den Angeben der MeStationsPositionen
'  ERRomg_grd   - WinkelDifferenz zum VollKreis
'
'........................................................................................................


'........................................................................ UMRECHNUNG DER POSITIONS-WINKEL

  For STCi% = 1 To 3
    ALPstl_bgm(STCi%) = Pi090 * ALPstc_lnc(STCi%) / RCTstc_hrz(STCi%)
    BTAstl_bgm(STCi%) = Pi090 * BTAstc_lnc(STCi%) / RCTstc_hrz(STCi%)
    GMAstl_bgm(STCi%) = Pi090 * GMAstc_lnc(STCi%) / RCTstc_vtc(STCi%)
  Next STCi%


'............................................. RAUMKOORDINATEN UND WINKEL DER ABSTANDS-LINIEN ZUR Z-ACHSE
'
'                                              DSTstl_pxz
'                              -------------------------------------------0
'                                    .       GMA                          |
'                                            .                            |
'                                                    .                    | YYY
'                                                           .             |
'                                                                   .     |
'                                                                         |
'........................................................................................................
'
'                                                         ZZZn            |
'                              -------------------------------------------|--------
'                                                           :           ..|
'                                                           : OMGn-1 .  . |
'                                                           :     .    .  |
'                                                           :  .      .   |
'                                                           :        .    |
'                                                        .  :       .     |
'                                                 Mn-1.     :      . OMGn |
'                                                    \BTAn-1:     .       |
'                                                     \     :    .        |
'                                                      \    :   . DSTn    |
'                                                       \   :  .          |
'                                                        \ALPn.           |
'                                                         \ :.            |
'                                                          \..............| XXXn
'                                                          . Mn           |
'                                                        N.
'........................................................................................................


'............................................................................................ Mestelle 1
DSTstl_pxz(1) = DSTstc_lnc(1) * Cos(-GMAstl_bgm(1))
ZZZstc_loc(1) = DSTstl_pxz(1)

  '.................................................................................... brige Mestellen
  For STCi% = 2 To 3
    DSTstl_pxz(STCi%) = DSTstc_lnc(STCi%) * Cos(-GMAstl_bgm(STCi%))
    OMGstl_bgm(STCi%) = OMGstl_bgm(STCi% - 1) + Pi180 - ALPstl_bgm(STCi%) + BTAstl_bgm(STCi% - 1)
    
    XXXstc_loc(STCi%) = DSTstl_pxz(STCi%) * Sin(OMGstl_bgm(STCi%))
    ZZZstc_loc(STCi%) = DSTstl_pxz(STCi%) * Cos(OMGstl_bgm(STCi%))
    YYYstc_loc(STCi%) = DSTstl_pxz(STCi%) * Sin(-GMAstl_bgm(STCi%))
  Next STCi%

'................................................................................ Differenz zum VollKreis
ERRomg_grd = 200 - (OMGstl_bgm(3) - ALPstl_bgm(1) + BTAstl_bgm(3)) * (100 / Pi090)
If ERRomg_grd < 200 Then ERRomg_grd = ERRomg_grd + 400
If ERRomg_grd > 200 Then ERRomg_grd = ERRomg_grd - 400


'********************************************************************************************************
                                                                                                  End Sub





'********************************************************************************************************
'********************************* EINBLENDEN GEBUNDENER FORMULARE **************************************
'
    Sub SacFrmShwModal(OBJfnc_s1x, LFTfrm%, TOPfrm%, WDTfrm%, HGHfrm%)
'
'........................................................................................................

OBJfnc_s1x.Move LFTfrm%, TOPfrm%, WDTfrm%, HGHfrm%

OBJfnc_s1x.AutoRedraw = 1
OBJfnc_s1x.DrawWidth = 2

C1& = &HFFFFFF: C2& = &H808080
OBJfnc_s1x.Line (0, 0)-(WDTfrm% - 15, HGHfrm% - 15), C1&, B
OBJfnc_s1x.Line (45, HGHfrm% - 15)-(WDTfrm% - 15, HGHfrm% - 15), C2&
OBJfnc_s1x.Line (WDTfrm% - 15, 30)-(WDTfrm% - 15, HGHfrm% - 15), C2&

OBJfnc_s1x.DrawWidth = 1
OBJfnc_s1x.Line (0, 0)-(WDTfrm% - 15, HGHfrm% - 15), 0, B
OBJfnc_s1x.PSet (15, HGHfrm% - 15), C2&
OBJfnc_s1x.PSet (WDTfrm% - 15, 15), C2&

'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'********************************************************************************************************
'
  Sub _()
'
'........................................................................................................


'********************************************************************************************************
'********************************************************************************************************
'
'
'........................................................................................................



'********************************************************************************************************
'                                                                                                  End Sub


'========================================================================================================
'========================================================================================================
'
'
'........................................................................................................

'========================================================================================================
'                                                                                             End Function
End Sub

'********************************************************************************************************
'********************************************************************************************************
'
  Sub SacIniAltitude()
'
'........................................................................................................

Pi090 = 2 * Atn(1)
Pi180 = 3.14159265358979
Pi360 = 6.28318530717958

FLNatt_dat = Right(Date$, 4) + Left(Date$, 2) + Mid(Date$, 4, 2) + ".dat"
DTMsys_nbr = Mid(Date$, 4, 2) + "." + Left(Date$, 2) + "." + Right(Date$, 4)

On Error Resume Next
If Dir$("S1X_AC.INI") = "" Then ChDrive Left(App.Path, 1): ChDir App.Path
If Dir$("S1X_AC.INI") = "" Then ChDrive "D": ChDir "D:\BASIC\PROJECTS\ALTITUDE.ENG"
On Error GoTo 0

PTHatt_hom = CurDir

  If Dir$("S1X_AC.INI") > "" Then
    Open "S1X_AC.INI" For Input As #99
    INI$ = Input$(LOF(99), #99)
    Close #99
  End If
  

SCTtxt$ = SacIniGetSct$(INI$, "ALTITUDE-CALCULATOR")
  
  If SCTtxt$ > "" Then
    LFTfrm_ctr = Val(SacIniGetOpt$(SCTtxt$, "LFT_CTR"))
    TOPfrm_ctr = Val(SacIniGetOpt$(SCTtxt$, "TOP_CTR"))
    
    LFTfrm_stc = Val(SacIniGetOpt$(SCTtxt$, "LFT_STC"))
    TOPfrm_stc = Val(SacIniGetOpt$(SCTtxt$, "TOP_STC"))
    
    LFTfrm_loc = Val(SacIniGetOpt$(SCTtxt$, "LFT_LOC"))
    TOPfrm_loc = Val(SacIniGetOpt$(SCTtxt$, "TOP_LOC"))
    
    LFTfrm_msr = Val(SacIniGetOpt$(SCTtxt$, "LFT_MSR"))
    TOPfrm_msr = Val(SacIniGetOpt$(SCTtxt$, "TOP_MSR"))
  End If
  
    If LFTfrm_ctr + TOPfrm_ctr = 0 Then
      LFTfrm_ctr = 0.5 * (Screen.Width - SAC_CTR.Width)
      TOPfrm_ctr = 0.5 * (Screen.Height - SAC_CTR.Height)
      LFTfrm_stc = LFTfrm_ctr + 900: TOPfrm_stc = TOPfrm_ctr + 900
      LFTfrm_loc = LFTfrm_stc - 450: TOPfrm_loc = TOPfrm_stc - 450
      LFTfrm_msr = LFTfrm_ctr - 450: TOPfrm_msr = TOPfrm_ctr - 450
    End If
    
    
  For STCi% = 1 To 3
    SCTtxt$ = SacIniGetSct$(INI$, "STATION" + Str(STCi%))
      
      If SCTtxt$ > "" Then
        RCTstc_hrz(STCi%) = Val(SacIniGetOpt$(SCTtxt$, "RCT_HRZ"))
        RCTstc_vtc(STCi%) = Val(SacIniGetOpt$(SCTtxt$, "RCT_VTC"))
      
        ALPstc_lnc(STCi%) = Val(SacIniGetOpt$(SCTtxt$, "LFT_HRZ"))
        BTAstc_lnc(STCi%) = Val(SacIniGetOpt$(SCTtxt$, "RGT_HRZ"))
      
        GMAstc_lnc(STCi%) = Val(SacIniGetOpt$(SCTtxt$, "GMA_LNC"))
        DSTstc_lnc(STCi%) = Val(SacIniGetOpt$(SCTtxt$, "DST_LNC"))
        
        ALPmsr_apg(STCi%) = Val(SacIniGetOpt$(SCTtxt$, "ALP_APG"))
        GMAmsr_apg(STCi%) = Val(SacIniGetOpt$(SCTtxt$, "GMA_APG"))
      End If
        
          If RCTstc_hrz(STCi%) = 0 Then RCTstc_hrz(STCi%) = 90
          If RCTstc_vtc(STCi%) = 0 Then RCTstc_vtc(STCi%) = 100
          If ALPstc_lnc(STCi%) = 0 Then ALPstc_lnc(STCi%) = 30
          If BTAstc_lnc(STCi%) = 0 Then BTAstc_lnc(STCi%) = -30
          If DSTstc_lnc(STCi%) = 0 Then DSTstc_lnc(STCi%) = 300
      
  Next STCi%

SacClcMsrLocation

'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'********************************************************************************************************
'
  Sub SacSavSettings()
'
'........................................................................................................


Open PTHatt_hom + "\S1X_AC.INI" For Output As #99

Print #99, "[ALTITUDE-CALCULATOR]"
Print #99, "LFT_CTR ="; LFTfrm_ctr: Print #99, "TOP_CTR ="; TOPfrm_ctr
Print #99, "LFT_STC ="; LFTfrm_stc: Print #99, "TOP_STC ="; TOPfrm_stc
Print #99, "LFT_LOC ="; LFTfrm_loc: Print #99, "TOP_LOC ="; TOPfrm_loc
Print #99, "LFT_MSR ="; LFTfrm_msr: Print #99, "TOP_MSR ="; TOPfrm_msr
Print #99, ""

  For STCi% = 1 To 3
    Print #99, "[STATION" + Str(STCi%) + "]"
    Print #99, "RCT_HRZ ="; RCTstc_hrz(STCi%): Print #99, "RCT_VTC ="; RCTstc_vtc(STCi%)
    Print #99, "LFT_HRZ ="; Str(ALPstc_lnc(STCi%)): Print #99, "RGT_HRZ ="; Str(BTAstc_lnc(STCi%))
    Print #99, "GMA_LNC ="; Str(GMAstc_lnc(STCi%)): Print #99, "DST_LNC ="; Str(DSTstc_lnc(STCi%))
    
    Print #99, "ALP_APG ="; Str(ALPmsr_apg(STCi%)): Print #99, "GMA_APG ="; Str(GMAmsr_apg(STCi%))
    Print #99, ""
  Next STCi%

Print #99, ""

Close

'********************************************************************************************************
                                                                                                  End Sub



'========================================================================================================
'========================================================================================================
'
  Function StcCtrFmtInpValue$(VALx$)
'
'........................................................................................................


Pk% = InStr(VALx$, ",")
If Pk% > 0 Then Mid(VALx$, Pk%, 1) = "."
VALfmt$ = LTrim(Str(Val(VALx$)))

If Left(VALfmt$, 1) = "." Then VALfmt$ = "0" + VALfmt$
Pk% = InStr(VALfmt$, ".")
If Pk% > 0 Then Mid(VALfmt$, Pk%, 1) = ","

StcCtrFmtInpValue$ = VALfmt$

'========================================================================================================
                                                                                             End Function

'========================================================================================================
'========================================================================================================
'
   Private Function SacIniGetSct$(INI$, SCTx$)
'
'........................................................................................................

    
   SacIniGetSct$ = ""
   
   Pq% = InStr(UCase$(INI$), "[" + SCTx$ + "]")
     If Pq% = 0 Then Exit Function
         
   P1% = InStr(Pq%, INI$, Chr$(10)) + 1
     If P1% = 1 Then Exit Function

   P2% = InStr(P1%, INI$, Chr$(10) + "[") + 1
     If P2% = 1 Then P2% = Len(INI$) + 1
   
   SacIniGetSct$ = Mid$(INI$, P1%, P2% - P1%)

'========================================================================================================
                                                                                             End Function

'========================================================================================================
'========================================================================================================
'
   Private Function SacIniGetOpt$(SCTtxt$, OPTx$)
'
'........................................................................................................

   SacIniGetOpt$ = ""
   
   Pq% = InStr(UCase$(SCTtxt$), OPTx$)
     If Pq% = 0 Then Exit Function
         
   P1% = InStr(Pq%, SCTtxt$, "=") + 1
     If P1% = 1 Then Exit Function
                 
   P2% = InStr(P1%, SCTtxt$, Chr$(13))
     If P2% = 0 Then P2% = Len(SCTtxt$) + 1
   
   
   SacIniGetOpt$ = LTrim$(RTrim$(Mid$(SCTtxt$, P1%, P2% - P1%)))

'========================================================================================================
                                                                                             End Function

'********************************************************************************************************
'*********************** BERECHNUNG DES PEILUNGS-FEHLERS EINES STATIONS-PRCHENS ************************
'
  Sub SacClcDuoError(DUOx%)
'
'........................................................................................................

      
  Select Case DUOx%
    Case 1: STCx% = 1: GoSub ClcDuoError: STCx% = 2: GoSub ClcDuoError
    Case 2: STCx% = 2: GoSub ClcDuoError: STCx% = 3: GoSub ClcDuoError
    Case 3: STCx% = 3: GoSub ClcDuoError: STCx% = 1: GoSub ClcDuoError
  End Select


ERRduo_hrz(DUOx%) = Fix(50 * ERRhrz_bgm# / Pi090)
ERRduo_vtc(DUOx%) = Fix(50 * ERRvtc_bgm# / Pi090)
  
  If Not (ERRduo_hrz(DUOx%) > 5 Or ERRduo_vtc(DUOx%) > 5) Then
    CLCduo_apg(DUOx%) = 1
  Else
    CLCduo_apg(DUOx%) = 0
  End If

  
                                                                                                 Exit Sub
'********************************************************************************************************
'--------------------------------------------------------------------------------------------------------
'--------------------------------------------------------------------------------------------------------
ClcDuoError:
'....................................................... AbstandsKoordinaten zwischen Station und Apogum
DX# = XXXduo_apg(DUOx%) - XXXstc_loc(STCx%): DX# = Fix(DX#)
DY# = YYYduo_apg(DUOx%) - YYYstc_loc(STCx%): DY# = Fix(DY#)
DZ# = ZZZduo_apg(DUOx%) - ZZZstc_loc(STCx%): DZ# = Fix(DZ#)

'.......................................................... HorizontalWinkel zwischen Station und Apogum
  
  If DZ# <> 0 Then
    ALPstc_apg# = Atn(DX# / DZ#)
    If DZ# < 0 Then ALPstc_apg# = ALPstc_apg# + Pi180
  Else
    If DX# <> 0 Then ALPstc_apg# = Sgn(DX#) * Pi180 / 2
    
      If DX# <> 0 Then
        ALPstc_apg# = Sgn(DX#) * Pi180 / 2
      Else
        ALPstc_apg# = OMGstl_bgm(STCx%) + ALPapg_bgm(STCx%) + Pi180
      End If

  End If

If ALPstc_apg# < 0 Then ALPstc_apg# = ALPstc_apg# + Pi360
If ALPstc_apg# > Pi360 Then ALPstc_apg# = ALPstc_apg# - Pi360

'........................................................................... HorizontalWinkel der Peilung
ALPmsr# = OMGstl_bgm(STCx%) + ALPapg_bgm(STCx%) + Pi180
If ALPmsr# < 0 Then ALPmsr# = ALPmsr# + Pi360
If ALPmsr# > Pi360 Then ALPmsr# = ALPmsr# - Pi360

'............................................................ VertikalWinkel zwischen Station und Apogum
DXZ# = Sqr(DX# ^ 2 + DZ# ^ 2)
If DXZ# <> 0 Then GMAstc_apg# = Atn(DY# / DXZ#) Else GMAstc_apg# = Pi090

'................................................................................................. Fehler
ERRhrz_bgm# = ERRhrz_bgm# + Abs(ALPmsr# - ALPstc_apg#)
    
ERRvtc_bgm# = ERRvtc_bgm# + Abs(GMAapg_bgm(STCx%) - GMAstc_apg#)
                                                                                                   Return
'--------------------------------------------------------------------------------------------------------
'********************************************************************************************************
                                                                                                  End Sub



