Attribute VB_Name = "CLC_FNC"

Dim XXXduo_fly&(), ZZZduo_fly&(), YYYduo_fly&() '..................................... VisierMittelpunkte
Dim DALduo_fly%() '...................................................... Abweichung der HorizontalWinkel
Dim DGMduo_fly%() '........................................................ Abweichung der VerticalWinkel
Dim STSduo_fly$() '............................................................................... Status

Dim ALTcmp&(), IDXrec%()

Dim DATduo_fly%() '............................................................................ DatenFlag
Dim ALPsfl_bgm#() '........................................... Werte ALPstc_fly() umgerechnet in Bogenma
Dim GMAsfl_bgm#() '........................................... Werte GMAstc_fly() umgerechnet in Bogenma

'********************************************************************************************************
'*************** ANZEIGEN DER DATEN DES AKTUELLEN WETTKMPFERS IM FORMULAR CALCULATIONS *****************
'
  Sub ClcCtrSetCompetitor()
'
'........................................................................................................

  If CmpCtr.IDXrec = 0 Then Exit Sub

P1% = InStr(CmpCtr.RECdat(CmpCtr.IDXrec), Chr(1))
P2% = InStr(CmpCtr.RECdat(CmpCtr.IDXrec), Chr(2))
P3% = InStr(CmpCtr.RECdat(CmpCtr.IDXrec), Chr(3))

NBRx$ = Left(CmpCtr.RECdat(CmpCtr.IDXrec), P1% - 1)
NAMx$ = Mid(CmpCtr.RECdat(CmpCtr.IDXrec), P1% + 1, P2% - P1% - 1)
ADDx$ = Mid(CmpCtr.RECdat(CmpCtr.IDXrec), P2% + 1, P3% - P2% - 1)

CMPtxt$ = NBRx$ + "  " + NAMx$
If ADDx$ > "" Then CMPtxt$ = CMPtxt$ + " - " + ADDx$

  
CLC_CTR.CmpPct.BackColor = CLC_CTR.BackColor
  
CLC_CTR.CmpPct.ForeColor = &HFFFFFF
CLC_CTR.CmpPct.CurrentX = 15: CLC_CTR.CmpPct.CurrentX = 15: CLC_CTR.CmpPct.Print CMPtxt$;

CLC_CTR.CmpPct.ForeColor = &H800000
CLC_CTR.CmpPct.CurrentX = 0: CLC_CTR.CmpPct.CurrentX = 0: CLC_CTR.CmpPct.Print CMPtxt$;

TXTx$ = "StationPair-Calculations of Flight" + Str(IDXfly_s1x) + " for Competitor" + Str(Val(NBRx$)) + " ..."
S1xFrmInfText CLC_CTR, TXTx$

'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'************************ LADEN DER PEILUNGS-DATEN EINES FLUGES EINES WETTKMPFERS **********************
'
  Sub ClcCtrLodDuoData()
'
'        Abgesetzt >> Interpretation der Daten:  TrackLost = kein Record
'              Neu >> TrackLost = TL , kein Record, Messung steht noch aus
'........................................................................................................

STSfly$ = STScmp_fly(CmpCtr.IDXrec, IDXfly_s1x)
  
  
    If STSfly$ = "" Or STSfly$ = "DQ" Or STSfly$ = "TL" Then
      ClcCtr.NBRrec = 0
      CLC_CTR.RecLstPct.BackColor = COLbkc_lst
      CLC_CTR.ScrBarPct.Visible = 0
      Exit Sub
    End If
  
  
ClcCtr.NBRrec = NBRstc_duo

ReDim DATduo_fly%(StcCtr.NBRrec, StcCtr.NBRrec)
ReDim YYYduo_fly&(StcCtr.NBRrec, StcCtr.NBRrec)
ReDim DALduo_fly%(StcCtr.NBRrec, StcCtr.NBRrec)
ReDim DGMduo_fly%(StcCtr.NBRrec, StcCtr.NBRrec)
ReDim STSduo_fly$(StcCtr.NBRrec, StcCtr.NBRrec)


'................................................................. StartNummer des aktuellen Wettkmpfers
Pq% = InStr(CmpCtr.RECdat(CmpCtr.IDXrec), Chr(1))
CMPnbr$ = Left(CmpCtr.RECdat(CmpCtr.IDXrec), Pq% - 1)
  

        QRYx$ = " SELECT "
QRYx$ = QRYx$ + " st1_index, st2_index, hgh, hrz_err, vtc_err, sts"
QRYx$ = QRYx$ + " FROM s1x_clc "
QRYx$ = QRYx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
QRYx$ = QRYx$ + "  AND cmp_index =" + CMPnbr$
QRYx$ = QRYx$ + "  AND fly_index =" + Str(IDXfly_s1x)
QRYx$ = QRYx$ + " ORDER BY st1_index, st2_index"

Set CRSobj_s1x = DBSobj_s1x.OpenRecordset(QRYx$, 2, 4)

  Do While Not CRSobj_s1x.EOF
    IDXst1% = CRSobj_s1x(0): IDXst2% = CRSobj_s1x(1)
    
    DATduo_fly%(IDXst1%, IDXst2%) = 1
    If Not IsNull(CRSobj_s1x(2)) Then YYYduo_fly&(IDXst1%, IDXst2%) = CRSobj_s1x(2)
    If Not IsNull(CRSobj_s1x(3)) Then DALduo_fly%(IDXst1%, IDXst2%) = CRSobj_s1x(3)
    If Not IsNull(CRSobj_s1x(4)) Then DGMduo_fly%(IDXst1%, IDXst2%) = CRSobj_s1x(4)
    If Not IsNull(CRSobj_s1x(5)) Then STSduo_fly$(IDXst1%, IDXst2%) = CRSobj_s1x(5)
        
    CRSobj_s1x.MoveNext
  Loop

CRSobj_s1x.Close
  

DUOi% = 0

  For STC1% = 1 To StcCtr.NBRrec - 1
    NBR1$ = LTrim(Str(STC1%)): If STC1% < 10 Then NBR1$ = "0" + NBR1$
    
      For STC2% = STC1% + 1 To StcCtr.NBRrec
        NBR2$ = LTrim(Str(STC2%)): If STC2% < 10 Then NBR2$ = "0" + NBR2$
        RECx$ = NBR1$ + " - " + NBR2$ + Chr(1)
          
          If DATduo_fly%(STC1%, STC2%) = 1 Then
          
              If Not STSduo_fly$(STC1%, STC2%) = "TL" Then
                RECx$ = RECx$ + LTrim(Str(YYYduo_fly&(STC1%, STC2%))) + Chr(2)
                RECx$ = RECx$ + LTrim(Str(DALduo_fly%(STC1%, STC2%))) + Chr(3)
                RECx$ = RECx$ + LTrim(Str(DGMduo_fly%(STC1%, STC2%))) + Chr(4)
              Else
                RECx$ = RECx$ + "- - " + Chr(2) + "- - " + Chr(3) + "- - " + Chr(4)
              End If
              
            RECx$ = RECx$ + STSduo_fly$(STC1%, STC2%) + Chr(5)
          Else
            RECx$ = RECx$ + Chr(2) + Chr(3) + Chr(4) + Chr(5)
          End If
        
        DUOi% = DUOi% + 1
        ClcCtr.RECdat(DUOi%) = RECx$
      Next STC2%
      
  Next STC1%
  
ClcCtr.NBRscr = 0
ClcCtr.IDXrec = 1
  
ClcCtrShwRecList
If ClcCtr.NBRrec > ClcCtr.NBRrow Then S1xFrmIniScrBar CLC_CTR, ClcCtr.NBRrec, ClcCtr.NBRrow, ClcCtr.NBRscr


'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'******************************** ANZEIGE DER ERGEBNISSE DER STATIONS-PAARE *****************************
'
  Sub ClcCtrShwRecList()
'
'........................................................................................................


CLC_CTR.RecLstPct.ForeColor = COLrec_lst
CLC_CTR.RecLstPct.FontBold = BLDrec_lst


X1% = 150: X2% = CLC_CTR.RecLstPct.Width - 120
DY% = TOPspc_lst - HGHrow_lst

  If CLC_CTR.RecLstPct.AutoRedraw = 0 Then
    
      For ROWi% = 1 To ClcCtr.NBRrow
        RECx% = ROWi% + ClcCtr.NBRscr
    
        YY& = DY% + ROWi% * HGHrow_lst
        Y1% = YY& - 30: Y2% = YY& + HGHfrm_lst
        CLC_CTR.RecLstPct.Line (X1%, Y1%)-(X2%, Y2%), COLbkc_lst, BF
          If RECx% > ClcCtr.NBRrec Then Exit For
    
        ClcCtrShwRecord RECx%, YY&
      Next ROWi%

  Else
    CLC_CTR.RecLstPct.BackColor = COLbkc_lst
    
      For ROWi% = 1 To ClcCtr.NBRrow
        RECx% = ROWi% + ClcCtr.NBRscr
          If RECx% > ClcCtr.NBRrec Then Exit For
    
        YY& = DY% + ROWi% * HGHrow_lst
        ClcCtrShwRecord RECx%, YY&
      Next ROWi%
    
  End If
  

'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'**************************************** ANZEIGE EINES RECORDS *****************************************
'
  Sub ClcCtrShwRecord(RECx%, YY&)
'
'........................................................................................................
      
CLC_CTR.RecLstPct.CurrentY = YY&

CLMi% = 1: P2% = InStr(ClcCtr.RECdat(RECx%), Chr(CLMi%))
VALx$ = Mid(ClcCtr.RECdat(RECx%), 1, P2% - 1)
CLC_CTR.RecLstPct.CurrentX = 300
CLC_CTR.RecLstPct.Print VALx$;

CLMi% = 2
P1% = P2% + 1: P2% = InStr(P1%, ClcCtr.RECdat(RECx%), Chr(CLMi%))
VALx$ = Mid(ClcCtr.RECdat(RECx%), P1%, P2% - P1%)
If VALx$ > "" And VALx$ <> "- - " Then VALx$ = VALx$ + " m"
CLC_CTR.RecLstPct.CurrentX = ClcCtr.TABlst(CLMi%) - CLC_CTR.RecLstPct.TextWidth(VALx$)
CLC_CTR.RecLstPct.Print VALx$;

  For CLMi% = 3 To 4
    P1% = P2% + 1: P2% = InStr(P1%, ClcCtr.RECdat(RECx%), Chr(CLMi%))
    VALx$ = Mid(ClcCtr.RECdat(RECx%), P1%, P2% - P1%)
    If VALx$ > "" And VALx$ <> "- - " Then VALx$ = VALx$ + ""
    CLC_CTR.RecLstPct.CurrentX = ClcCtr.TABlst(CLMi%) - CLC_CTR.RecLstPct.TextWidth(VALx$)
    CLC_CTR.RecLstPct.Print VALx$;
    
  Next CLMi%

CLMi% = 5
P1% = P2% + 1: P2% = InStr(P1%, ClcCtr.RECdat(RECx%), Chr(CLMi%))
VALx$ = Mid(ClcCtr.RECdat(RECx%), P1%, P2% - P1%)
CLC_CTR.RecLstPct.CurrentX = ClcCtr.TABlst(CLMi%) - 0.5 * CLC_CTR.RecLstPct.TextWidth(VALx$)
CLC_CTR.RecLstPct.Print VALx$;

'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'******************** ANZEIGEN DESINDEX DES AKTUELLEN FLUGES IM FORMULAR CALCULATIONS *******************
'
  Sub ClcCtrSetFlyIndex(IDXfly%)
'
'........................................................................................................
  
CLC_CTR.FlyImg.Top = -300 * (IDXfly% - 1)

'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'*********************************** NEUBERECHNUNG EINES FLUGES *****************************************
'
  Sub ClcCtrClcFlight(IDXcmp%, IDXfly%)
'
'........................................................................................................


'......................................................................... UMRECHNUNG DER PEILUNGS-WINKEL
ReDim ALPsfl_bgm#(StcCtr.NBRrec), GMAsfl_bgm#(StcCtr.NBRrec)

  For STCi% = 1 To StcCtr.NBRrec
    ALPsfl_bgm#(STCi%) = Pi090 * ALPstc_fly(STCi%) / RCTstc_hrz(STCi%)
    GMAsfl_bgm#(STCi%) = Pi090 * GMAstc_fly(STCi%) / RCTstc_vtc(STCi%)
    
      If GMAsfl_bgm#(STCi%) > Pi090 Then
        GMAsfl_bgm#(STCi%) = Pi090 - (GMAsfl_bgm#(STCi%) - Pi090)
        ALPsfl_bgm#(STCi%) = ALPsfl_bgm#(STCi%) - Pi180
        If ALPsfl_bgm#(STCi%) < 0 Then ALPsfl_bgm#(STCi%) = ALPsfl_bgm#(STCi%) + Pi360
      End If
      
  Next STCi%

'..................................................................... BERECHNUNG DER PEILUNGS-ERGEBNISSE
ReDim XXXduo_fly&(NBRstc_duo), ZZZduo_fly&(NBRstc_duo), YYYduo_fly&(NBRstc_duo) '..... VisierMittelpunkte
ReDim DALduo_fly%(NBRstc_duo) '.......................................... Abweichung der HorizontalWinkel
ReDim DGMduo_fly%(NBRstc_duo) '............................................ Abweichung der VerticalWinkel
ReDim STSduo_fly$(NBRstc_duo) '................................................................... Status


CLCstp! = 0.5 '.................................................... Vertikale Schrittweite der Berechnung
NBRduo_vld% = 0 '............................................. Anzahl MestellenPaare mit gltigen Werten
YYYmax# = 0: YYYmin# = 99999 '............................................................... ExtremWerte
DUOx% = 0

  For STC1% = 1 To StcCtr.NBRrec
      
      If Not GMAsfl_bgm#(STC1%) = 0 Then
        TNGgma1# = Tan(GMAsfl_bgm#(STC1%))
        
        PHI1# = OMGstl_bgm(STC1%) + ALPsfl_bgm#(STC1%) + Pi180
        SNStng1# = Sin(PHI1#) / TNGgma1#
        CSNtng1# = Cos(PHI1#) / TNGgma1#
    
    
          For STC2% = STC1% + 1 To StcCtr.NBRrec
            DUOx% = DUOx% + 1
            
              If Not GMAsfl_bgm#(STC2%) = 0 Then
                                                                       '                 -------------/
                                                                       '                  ^          /:
                                                                       '                  |         / :
                                                                       '           CLCstp |        /  :
                                                                       '                  |       /   :
                                                                       '                  v      /    :
                                                                       '                 -------/     :
                                                                       '                       /: GMA :
                                                                       '                      / :     :
                                                                       '                      -----------
                                                                       '                           DXZ
        
                TNGgma2# = Tan(GMAsfl_bgm#(STC2%))
                                                                       '           Z              |
                                                                       '  ---------:--------------.-
                                                                       '       .   :         OMG .|
                                                                       '        .  :            . |
                                                                       '         . :           .  |
                                                                       '          .:          .   |
                                                                       '           ...............|X
                                                                       '            .       .     |
                                                                       '         DXZ .     .      |
                                                                       '              .ALP.       |
                                                                       '               . .        |
                                                                       '           PHI  .         |
       
                PHI2# = OMGstl_bgm(STC2%) + ALPsfl_bgm#(STC2%) + Pi180
                SNStng2# = Sin(PHI2#) / TNGgma2#
                CSNtng2# = Cos(PHI2#) / TNGgma2#
       
        
                YYY0# = YYYstc_loc(STC1%) '................................................. AusgangsHhe
                If YYYstc_loc(STC2%) > YYY0# Then YYY0# = YYYstc_loc(STC2%)
                
                '......................................... Abstand der PeilungsLinien in der AusgangsHhe
                YYYx# = YYY0#
                Y1# = YYYx# - YYYstc_loc(STC1%)
                X1# = XXXstc_loc(STC1%) + Y1# * SNStng1#: Z1# = ZZZstc_loc(STC1%) + Y1# * CSNtng1#
                
                Y2# = YYYx# - YYYstc_loc(STC2%)
                X2# = XXXstc_loc(STC2%) + Y2# * SNStng2#: Z2# = ZZZstc_loc(STC2%) + Y2# * CSNtng2#
                
                DSTmin# = (X1# - X2#) ^ 2 + (Z1# - Z2#) ^ 2
                  
                  '......................................... Ermittlung der Hhe des geringsten Abstandes
                  Do
                    Y1# = YYYx# + CLCstp! - YYYstc_loc(STC1%)
                    X1# = XXXstc_loc(STC1%) + Y1# * SNStng1#: Z1# = ZZZstc_loc(STC1%) + Y1# * CSNtng1#
                  
                    Y2# = YYYx# + CLCstp! - YYYstc_loc(STC2%)
                    X2# = XXXstc_loc(STC2%) + Y2# * SNStng2#: Z2# = ZZZstc_loc(STC2%) + Y2# * CSNtng2#
                    
                    DDD# = (X1# - X2#) ^ 2 + (Z1# - Z2#) ^ 2
                      If Not DDD# < DSTmin# Then Exit Do
                  
                    DSTmin# = DDD#: YYYx# = YYYx# + CLCstp!
                  Loop
       
                  '.............................................................. Mittlere PeilungsFehler
                  If YYYx# > YYY0# + CLCstp! Then
                    YYYduo_fly&(DUOx%) = Fix(YYYx#)       '!! Festhalten fr Anzeige der PeilungLinien !!
                    XXXduo_fly&(DUOx%) = 0.5 * (X1# + X2#)
                    ZZZduo_fly&(DUOx%) = 0.5 * (Z1# + Z2#)
                    
                    STCx% = STC1%: GoSub ClcStcError
                    ERRhrz_bgm# = ERRhrz#: ERRvtc_bgm# = ERRvtc#
                    STCx% = STC2%: GoSub ClcStcError
                    
                    DALduo_fly%(DUOx%) = Fix(0.5 * RCTstc_hrz(STCx%) * (ERRhrz_bgm# + ERRhrz#) / Pi090)
                    DGMduo_fly%(DUOx%) = Fix(0.5 * RCTstc_vtc(STCx%) * (ERRvtc_bgm# + ERRvtc#) / Pi090)
                      
                      If DALduo_fly%(DUOx%) > HRZerr_max Or DGMduo_fly%(DUOx%) > VTCerr_max Then
                        STSduo_fly$(DUOx%) = "NC"
                      Else
                        NBRduo_vld% = NBRduo_vld% + 1
                        STSduo_fly$(DUOx%) = "OK"
                        If YYYduo_fly&(DUOx%) > YYYmax# Then YYYmax# = YYYduo_fly&(DUOx%): DUOmax% = DUOx%
                        If YYYduo_fly&(DUOx%) < YYYmin# Then YYYmin# = YYYduo_fly&(DUOx%): DUOmin% = DUOx%
                      End If
                      
                  Else
                    STSduo_fly$(DUOx%) = "NC"
                  End If
          
              Else
                STSduo_fly$(DUOx%) = "TL"
              End If
      
          Next STC2%
          
            
      Else
          
          For STC2% = STC1% + 1 To StcCtr.NBRrec
            DUOx% = DUOx% + 1
            STSduo_fly$(DUOx%) = "TL"
          Next STC2%

      End If
  
  Next STC1%
  
      
  Select Case NBRduo_vld%
    Case 0
      
      STSfly$ = "TL"
      
        For DUOi% = 1 To NBRstc_duo
          If STSduo_fly$(DUOi%) = "NC" Then STSfly$ = "NC": Exit For
        Next DUOi%
  
      YYYfly& = 0
    
    Case Is < MINstc_duo
    
      STSfly$ = "TL"
      YYYfly& = 0
    
    Case Else
      
        '................................................................... Ausschlieen der ExtremWerte
        If Not NBRduo_vld% < NBRmin_max Then
          STSduo_fly$(DUOmax%) = "MX": STSduo_fly$(DUOmin%) = "MN"
          NBRduo_clc% = NBRduo_vld% - 2
        Else
          NBRduo_clc% = NBRduo_vld%
        End If
  
      '.............................................................................. PeilungsMittelpunkt
      XXX# = 0: ZZZ# = 0: YYY# = 0
        
        For DUOi% = 1 To NBRstc_duo
      
          If STSduo_fly$(DUOi%) = "OK" Then
            XXX# = XXX# + XXXduo_fly&(DUOi%)
            ZZZ# = ZZZ# + ZZZduo_fly&(DUOi%)
            YYY# = YYY# + YYYduo_fly&(DUOi%)
          End If
      
        Next DUOi%
      
      XXXfly& = Fix(XXX# / NBRduo_clc%)
      ZZZfly& = Fix(ZZZ# / NBRduo_clc%)
      YYYfly& = Fix(YYY# / NBRduo_clc%)
      
      '........................................................................ PeilungsFehler des Fluges
      DDD# = 0
        
        For DUOi% = 1 To NBRstc_duo
          If STSduo_fly$(DUOi%) = "OK" Then DDD# = DDD# + Abs(YYYfly& - YYYduo_fly&(DUOi%))
        Next DUOi%
           
      ERRfly% = Fix(100 * (DDD# / NBRduo_clc%) / YYYfly&)
      If Not ERRfly% > HGHerr_max Then STSfly$ = "OK" Else STSfly$ = "NC"
    
  End Select
      
'............................................................................... SPEICHERN DER ERGEBNISSE
NBRcmp% = Val(CmpCtr.RECdat(IDXcmp%))
        
        '.................................................................. FlugErgebnis des Wettkmpfers
        QRYx$ = " SELECT * "
QRYx$ = QRYx$ + " FROM s1x_fly "
QRYx$ = QRYx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
QRYx$ = QRYx$ + "   AND cmp_index =" + Str(NBRcmp%)
QRYx$ = QRYx$ + "   AND fly_index =" + Str(IDXfly%)
On Error GoTo ClcAccErr
Set CRSobj_s1x = DBSobj_s1x.OpenRecordset(QRYx$, 2, 0)
On Error GoTo 0
  
  If Not CRSobj_s1x.EOF Then
    CRSobj_s1x.Edit
    On Error GoTo ClcUpdErr
  Else
    
    QRYx$ = " SELECT * FROM s1x_fly WHERE cnt_index = 0"
    On Error GoTo ClcAccErr
    Set CRSobj_s1x = DBSobj_s1x.OpenRecordset(QRYx$, 2, 0)
    On Error GoTo 0
  
      If Not CRSobj_s1x.EOF Then
        CRSobj_s1x.Edit
        On Error GoTo ClcUpdErr
        
        CRSobj_s1x("xxx_obs") = Null: CRSobj_s1x("zzz_obs") = Null: CRSobj_s1x("yyy_obs") = Null
        CRSobj_s1x("wdt_foc") = Null: CRSobj_s1x("lft_scc") = Null: CRSobj_s1x("top_scc") = Null
        
      Else
        Set CRSobj_s1x = DBSobj_s1x.OpenRecordset("s1x_fly", 2, 8)
        CRSobj_s1x.AddNew
        On Error GoTo ClcInsErr
      End If

  End If
          
    
CRSobj_s1x("cnt_index") = IDXcnt_s1x
CRSobj_s1x("cmp_index") = NBRcmp%
CRSobj_s1x("fly_index") = IDXfly%


  If Not STSfly$ = "TL" Then
    CRSobj_s1x("xxx") = XXXfly&:    CRSobj_s1x("zzz") = ZZZfly&
    CRSobj_s1x("hgh") = YYYfly&:    CRSobj_s1x("err") = ERRfly%
  Else
    CRSobj_s1x("xxx") = Null:       CRSobj_s1x("zzz") = Null
    CRSobj_s1x("hgh") = Null:       CRSobj_s1x("err") = Null
  End If

CRSobj_s1x("sts") = STSfly$
CRSobj_s1x.Update
On Error GoTo 0


        '........................................................................ Werte Der StationsPaare
        SQLx$ = " UPDATE s1x_clc"
SQLx$ = SQLx$ + " SET cnt_index = 0"
SQLx$ = SQLx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
SQLx$ = SQLx$ + "  AND cmp_index =" + Str(NBRcmp%)
SQLx$ = SQLx$ + "  AND fly_index =" + Str(IDXfly%)
On Error GoTo ClcUpdErr
DBSobj_s1x.Execute SQLx$
On Error GoTo 0

        QRYx$ = " SELECT * "
QRYx$ = QRYx$ + " FROM s1x_clc "
QRYx$ = QRYx$ + " WHERE cnt_index = 0"
On Error GoTo ClcAccErr
Set CRSobj_s1x = DBSobj_s1x.OpenRecordset(QRYx$, 2, 0)
On Error GoTo 0

DUOx% = 0

  For STC1% = 1 To StcCtr.NBRrec - 1

      For STC2% = STC1% + 1 To StcCtr.NBRrec
        DUOx% = DUOx% + 1
        If Not STSduo_fly$(DUOx%) = "" Then GoSub ClcFlySav
      Next STC2%

  Next STC1%

CRSobj_s1x.Close


ALTcmp_fly(IDXcmp%, IDXfly%) = YYYfly&
ERRcmp_fly(IDXcmp%, IDXfly%) = ERRfly%
STScmp_fly(IDXcmp%, IDXfly%) = STSfly$
        
                                                                                                 Exit Sub
'********************************************************************************************************
'--------------------------------------------------------------------------------------------------------
'--------------------------------------------------------------------------------------------------------
ClcFlySav:
              
  If QRYx$ > "" Then
      
      If Not (DUOx% > 35 Or CRSobj_s1x.EOF) Then
        CRSobj_s1x.Edit
        CRSobj_s1x("cnt_index") = IDXcnt_s1x
        CRSobj_s1x("cmp_index") = NBRcmp%
        CRSobj_s1x("fly_index") = IDXfly%
        CRSobj_s1x("st1_index") = STC1%:             CRSobj_s1x("st2_index") = STC2%
        CRSobj_s1x("hgh") = YYYduo_fly&(DUOx%)
        CRSobj_s1x("hrz_err") = DALduo_fly%(DUOx%):  CRSobj_s1x("vtc_err") = DGMduo_fly%(DUOx%)
        CRSobj_s1x("sts") = STSduo_fly$(DUOx%)
        
        On Error GoTo ClcUpdErr
        CRSobj_s1x.Update
        On Error GoTo 0
              
        CRSobj_s1x.MoveNext
        Return
      
      Else
        CRSobj_s1x.Close
        QRYx$ = ""
        Set CRSobj_s1x = DBSobj_s1x.OpenRecordset("s1x_clc", 2, 8)
      End If
      
    
  End If
            
CRSobj_s1x.AddNew

CRSobj_s1x("cnt_index") = IDXcnt_s1x
CRSobj_s1x("cmp_index") = NBRcmp%
CRSobj_s1x("fly_index") = IDXfly%
CRSobj_s1x("st1_index") = STC1%:            CRSobj_s1x("st2_index") = STC2%

  If Not STSduo_fly$(DUOx%) = "TL" Then
    CRSobj_s1x("hgh") = YYYduo_fly&(DUOx%)
    CRSobj_s1x("hrz_err") = DALduo_fly%(DUOx%):  CRSobj_s1x("vtc_err") = DGMduo_fly%(DUOx%)
  Else
    CRSobj_s1x("hgh") = Null
    CRSobj_s1x("hrz_err") = Null:                CRSobj_s1x("vtc_err") = Null
  End If
  
CRSobj_s1x("sts") = STSduo_fly$(DUOx%)

On Error GoTo ClcInsErr
CRSobj_s1x.Update
On Error GoTo 0
                                                                                                   Return
'--------------------------------------------------------------------------------------------------------
'--------------------------------------------------------------------------------------------------------
ClcStcError:

'....................................................... AbstandsKoordinaten zwischen Station und Apogum
DX# = XXXduo_fly&(DUOx%) - XXXstc_loc(STCx%): DX# = Fix(DX#)
DY# = YYYduo_fly&(DUOx%) - YYYstc_loc(STCx%): DY# = Fix(DY#)
DZ# = ZZZduo_fly&(DUOx%) - ZZZstc_loc(STCx%): DZ# = Fix(DZ#)

'.......................................................... HorizontalWinkel zwischen Station und Apogum

  If DZ# <> 0 Then
    ALPstc_apg# = Atn(DX# / DZ#)
    If DZ# < 0 Then ALPstc_apg# = ALPstc_apg# + Pi180
  Else
      
      If DX# <> 0 Then
        ALPstc_apg# = Sgn(DX#) * Pi180 / 2
      Else
        ALPstc_apg# = OMGstl_bgm(STCx%) + ALPsfl_bgm#(STCx%) + Pi180
      End If
      
  End If

If ALPstc_apg# < 0 Then ALPstc_apg# = ALPstc_apg# + Pi360
If ALPstc_apg# < 0 Then ALPstc_apg# = ALPstc_apg# + Pi360
If Not ALPstc_apg# < Pi360 Then ALPstc_apg# = ALPstc_apg# - Pi360
If Not ALPstc_apg# < Pi360 Then ALPstc_apg# = ALPstc_apg# - Pi360

'........................................................................... HorizontalWinkel der Peilung
ALPmsr# = OMGstl_bgm(STCx%) + ALPsfl_bgm#(STCx%) + Pi180
If ALPmsr# < 0 Then ALPmsr# = ALPmsr# + Pi360
If ALPmsr# < 0 Then ALPmsr# = ALPmsr# + Pi360
If Not ALPmsr# < Pi360 Then ALPmsr# = ALPmsr# - Pi360
If Not ALPmsr# < Pi360 Then ALPmsr# = ALPmsr# - Pi360

'.................................................................................... Horizontaler Fehler
ERRhrz# = Abs(ALPmsr# - ALPstc_apg#)
If Not ERRhrz# < Pi360 Then ERRhrz# = ERRhrz# - Pi360
If Not ERRhrz# < Pi360 Then ERRhrz# = ERRhrz# - Pi360

'............................................................ VertikalWinkel zwischen Station und Apogum
DXZ# = Sqr(DX# ^ 2 + DZ# ^ 2)
If DXZ# <> 0 Then GMAstc_apg# = Atn(DY# / DXZ#) Else GMAstc_apg# = Pi090

'...................................................................................... Vertikaler Fehler
ERRvtc# = Abs(GMAsfl_bgm#(STCx%) - GMAstc_apg#)
                                                                                                   Return
'--------------------------------------------------------------------------------------------------------
'--------------------------------------------------------------------------------------------------------
ClcAccErr:
S1xDbsAccError 1
Resume ClcInpEnd

ClcUpdErr:
S1xDbsAccError 2
Resume ClcInpEnd

ClcInsErr:
S1xDbsAccError 3
Resume ClcInpEnd

ClcInpEnd:
'--------------------------------------------------------------------------------------------------------
'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'****************************** NEUBERECHNUNG ALLER FLGE ALLER WETTKMPFER *****************************
'
  Sub ClcCtrClcContest()
'                                      Erforderlich bei nderungen an StationsDaten oder FehlerParametern
'........................................................................................................



'........................................................... Initialisieren der Records der ErgebnisListe
For I% = 4 To 14: NLLx$ = NLLx$ + Chr(I%): Next I%

  For CMPi% = 1 To CmpCtr.NBRrec
    PP% = InStr(CmpCtr.RECdat(CMPi%), Chr(3))
    CmpCtr.RECdat(CMPi%) = Left(CmpCtr.RECdat(CMPi%), PP%) + NLLx$
  Next CMPi%
  
CmpCtr.NBRscr = 0
CmpCtr.IDXrec = 1

  If Mid(LSTfrm_opn, 2, 1) = "*" Then
    CmpCtrShwRecList
    S1xFrmIniScrBar CMP_CTR, CmpCtr.NBRrec, CmpCtr.NBRrow, CmpCtr.NBRscr
    CMP_CTR.SetFocus
  Else
    CMP_CTR.Show
  End If
  
DoEvents

S1X_CTR.Enabled = 0
If Mid(LSTfrm_opn, 4, 1) = "*" Then Unload CLC_CTR
If Mid(LSTfrm_opn, 1, 1) = "*" Then STC_CTR.Enabled = 0
If Mid(LSTfrm_opn, 3, 1) = "*" Then MSR_CTR.Enabled = 0
If Mid(LSTfrm_opn, 2, 1) = "*" Then CMP_CTR.Enabled = 0
DoEvents
  
  
  For IDXcmp% = 1 To CmpCtr.NBRrec
      
      If IDXcmp% > CmpCtr.NBRscr + CmpCtr.NBRrow Then
        CmpCtr.NBRscr = IDXcmp% - CmpCtr.NBRrow
        CmpCtrShwRecList
        S1xFrmSetScrPointer CMP_CTR, CmpCtr.NBRrec, CmpCtr.NBRrow, CmpCtr.NBRscr
      End If
    
    CmpCtrDrwFrame IDXcmp%, 2
    If Mid(LSTfrm_opn, 3, 1) = "*" Then CmpCtr.IDXrec = IDXcmp%: MsrCtrSetCompetitor
    DoEvents
    
    '................................................................ MeDaten der Flge des Wettkmpfers
    
    '....................................................................... StartNummer des Wettkmpfers
    NBRcmp% = Val(CmpCtr.RECdat(IDXcmp%))
    ALTcmp_max& = 0
    
      For IDXfly% = 1 To 3
          
          If Mid(LSTfrm_opn, 3, 1) = "*" Then
            MSR_CTR.WrkCtrImg(IDXfly%).Top = -600
            IDXfly_s1x = IDXfly%: MsrCtrLodMsrData
            DoEvents
          End If
          
        STSx$ = ""
        NBRrec_clc% = 0
        
        
          Select Case STScmp_fly(IDXcmp%, IDXfly%)
            Case "" '.............................................................. Flug fand nicht statt
              ALTcmp_fly(IDXcmp%, IDXfly%) = 0
            
            Case "DQ" '.................................................................. Disqalifikation
              ALTcmp_fly(IDXcmp%, IDXfly%) = 0
              CmpCtrShwFlyData IDXcmp%, IDXfly%
            
            Case Else '........................................................ TL/NC/OK >> Neuberechnung
                
                If Not Mid(LSTfrm_opn, 3, 1) = "*" Then
                
                          QRYx$ = " SELECT stc_index, hrz_angle, vtc_angle"
                  QRYx$ = QRYx$ + " FROM s1x_msr"
                  QRYx$ = QRYx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
                  QRYx$ = QRYx$ + "   AND cmp_index =" + Str(NBRcmp%)
                  QRYx$ = QRYx$ + "   AND fly_index =" + Str(IDXfly%)
                  On Error GoTo ClcAccErr
                  Set CRSobj_s1x = DBSobj_s1x.OpenRecordset(QRYx$, 2, 4)
                  On Error GoTo 0
            
                  ReDim ALPstc_fly(StcCtr.NBRrec) As Single '................. Horizontale PeilungsWinkel
                  ReDim GMAstc_fly(StcCtr.NBRrec) As Single '................... Vertikale PeilungsWinkel
            
                    Do While Not CRSobj_s1x.EOF
                      
                        If Not IsNull(CRSobj_s1x(1)) Then
                          NBRrec_clc% = NBRrec_clc% + 1
                          IDXstc% = CRSobj_s1x(0)
                          ALPstc_fly(IDXstc%) = CRSobj_s1x(1)
                          GMAstc_fly(IDXstc%) = CRSobj_s1x(2)
                        End If
                        
                      CRSobj_s1x.MoveNext
                    Loop
                End If
            
            
            ClcCtrClcFlight IDXcmp%, IDXfly%
            CmpCtrShwFlyData IDXcmp%, IDXfly%
          End Select
      
      
              Select Case STScmp_fly(IDXcmp%, IDXfly%)
                Case "": ALTx& = 0
                Case "OK": ALTx& = ALTcmp_fly(IDXcmp%, IDXfly%)
                Case Else: ALTx& = 0
              End Select
      
            If ALTx& > ALTcmp_max& Then ALTcmp_max& = ALTx&
        
        If Mid(LSTfrm_opn, 3, 1) = "*" Then MSR_CTR.WrkCtrImg(IDXfly%).Top = 0
        DoEvents
      Next IDXfly%
    
        
      If ALTcmp_max& <> ALTcnt_cmp(IDXcmp%) Then
        ALTcnt_cmp(IDXcmp%) = ALTcmp_max&
                
                QRYx$ = " UPDATE s1x_cmp"
        QRYx$ = QRYx$ + " SET result =" + Str(ALTcmp_max&)
        QRYx$ = QRYx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
        QRYx$ = QRYx$ + "   AND cmp_index =" + Str(NBRcmp%)
        
        On Error GoTo ClcUpdErr
        DBSobj_s1x.Execute QRYx$
        On Error GoTo 0
      End If
      
    If Not ALTcnt_cmp(IDXcmp%) = 0 Then CmpCtrShwCmpResult IDXcmp%
    CmpCtrDrwFrame IDXcmp%, 0
    DoEvents
  Next IDXcmp%


ClcCtrClcCmpPositions
  
  For IDXcmp% = 1 To CmpCtr.NBRrec
    CmpCtrShwCmpPosition IDXcmp%
  Next IDXcmp%

IDXfly_s1x = 1
CmpCtr.NBRscr = 0
CmpCtr.IDXrec = 1

CmpCtrShwRecList
S1xFrmIniScrBar CMP_CTR, CmpCtr.NBRrec, CmpCtr.NBRrow, CmpCtr.NBRscr
CMP_CTR.RecLstPct.Enabled = 1
CmpCtrDrwFrame CmpCtr.IDXrec, 1

  If Mid(LSTfrm_opn, 3, 1) = "*" Then
    MsrCtrLodMsrData
    MsrCtrSetCompetitor
    MSR_CTR.WrkCtrImg(IDXfly_s1x).Top = -600
  End If

S1X_CTR.Enabled = 1
If Mid(LSTfrm_opn, 1, 1) = "*" Then STC_CTR.Enabled = 1
If Mid(LSTfrm_opn, 2, 1) = "*" Then CMP_CTR.Enabled = 1
If Mid(LSTfrm_opn, 3, 1) = "*" Then MSR_CTR.Enabled = 1
  
                                                                                                 Exit Sub
'********************************************************************************************************
ClcAccErr:
S1xDbsAccError 1
Resume ClcClcEnd

ClcUpdErr:
S1xDbsAccError 2
Resume ClcClcEnd

ClcClcEnd:

S1X_CTR.Enabled = 1
If Mid(LSTfrm_opn, 1, 1) = "*" Then STC_CTR.Enabled = 1
If Mid(LSTfrm_opn, 2, 1) = "*" Then CMP_CTR.Enabled = 1
If Mid(LSTfrm_opn, 3, 1) = "*" Then MSR_CTR.Enabled = 1

'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'******************************** BESTWERT DER FLGE EINES WETTKMPFERS *********************************
'
  Sub ClcCtrClcCmpResult(IDXcmp%)
'
'........................................................................................................

NBRcmp% = Val(CmpCtr.RECdat(IDXcmp%))

  For IDXfly% = 1 To 3
  
      Select Case STScmp_fly(IDXcmp%, IDXfly%)
        Case "":   ALTx& = 0
        Case "OK": ALTx& = ALTcmp_fly(IDXcmp%, IDXfly%): STScmp% = 1
        Case Else: ALTx& = 0: STScmp% = 1
      End Select
      
    If ALTx& > ALTcmp_max& Then ALTcmp_max& = ALTx&
  Next IDXfly%

    
  If ALTcmp_max& <> ALTcnt_cmp(IDXcmp%) Then
    ALTcnt_cmp(IDXcmp%) = ALTcmp_max&
            
            QRYx$ = " UPDATE s1x_cmp"
    QRYx$ = QRYx$ + " SET result =" + Str(ALTcmp_max&)
    QRYx$ = QRYx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
    QRYx$ = QRYx$ + "   AND cmp_index =" + Str(NBRcmp%)
    
    On Error GoTo ClcUpdErr
    DBSobj_s1x.Execute QRYx$
    On Error GoTo 0
  
    CmpCtrShwCmpResult IDXcmp%
  End If
      
                                                                                                 Exit Sub
'********************************************************************************************************
ClcUpdErr:
S1xDbsAccError 2
Resume ClcClcEnd

ClcClcEnd:
'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'**************************** BERECHNUNG DER PLATZIERUNGEN DER WETTKMPFER ******************************
'
  Sub ClcCtrClcCmpPositions()
'
'........................................................................................................

  
ReDim ALTcmp&(CmpCtr.NBRrec)
ReDim IDXrec%(CmpCtr.NBRrec)
ReDim POScmp%(CmpCtr.NBRrec)


  
  For IDXcmp% = 1 To CmpCtr.NBRrec
    ALTcmp&(IDXcmp%) = ALTcnt_cmp(IDXcmp%)
    IDXrec%(IDXcmp%) = IDXcmp%
  Next IDXcmp%
  
  
  '............................................................... Sortieren der Liste nach dem Brestwert
  For IDXcmp% = 1 To CmpCtr.NBRrec
    VALmax& = ALTcmp&(IDXcmp%)
    IDXmax% = 0
    
      For IDXver% = IDXcmp% + 1 To CmpCtr.NBRrec
        VALver& = ALTcmp&(IDXver%)
        If VALver& > VALmax& Then IDXmax% = IDXver%: VALmax& = VALver&
      Next IDXver%
      
          If IDXmax% > 0 Then
            ALTx& = ALTcmp&(IDXcmp%)
            IDXx% = IDXrec%(IDXcmp%)
            
            ALTcmp&(IDXcmp%) = ALTcmp&(IDXmax%)
            IDXrec%(IDXcmp%) = IDXrec%(IDXmax%)
            
            ALTcmp&(IDXmax%) = ALTx&
            IDXrec%(IDXmax%) = IDXx%
          End If
          
   Next IDXcmp%


'............................... Zuordnen der Platzierungen entsprechend der Sortierung nach dem Bestwert
POSprv% = 0
ALTprv& = 99999999

  For POSi% = 1 To CmpCtr.NBRrec
      
      If ALTcmp&(POSi%) = 0 Then Exit For
    
    If ALTcmp&(POSi%) < ALTprv& Then POSprv% = POSi%
    POScmp%(IDXrec%(POSi%)) = POSprv%
    ALTprv& = ALTcmp&(POSi%)
  Next POSi%
  
  
  '.............................................................. Speichern der vernderten Platzierungen
  For IDXcmp% = 1 To CmpCtr.NBRrec
          
    If POScmp%(IDXcmp%) <> POScnt_cmp(IDXcmp%) Then
      POScnt_cmp(IDXcmp%) = POScmp%(IDXcmp%)
      NBRcmp% = Val(CmpCtr.RECdat(IDXcmp%))
      
              UPDx$ = " UPDATE s1x_cmp"
      UPDx$ = UPDx$ + " SET place =" + Str(POScnt_cmp(IDXcmp%))
      UPDx$ = UPDx$ + " WHERE cnt_index =" + Str(IDXcnt_s1x)
      UPDx$ = UPDx$ + " AND cmp_index =" + Str(NBRcmp%)
      DBSobj_s1x.Execute UPDx$
    End If
      
  Next IDXcmp%
  
  '......................................... Eintragen der vernderten Platzierungen in die ErgebnisListe
  For IDXcmp% = 1 To CmpCtr.NBRrec
          
      
  Next IDXcmp%
  
'********************************************************************************************************
                                                                                                  End Sub


